/*
    Electrical Networks - Electrical network calculations
    Copyright © 2013,2015 Harry Whitfield

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the
	Free Software Foundation; either version 2 of the License, or (at your
	option) any later version.

	This program is distributed in the hope that it will be useful, but
	WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
	General Public License for more details.

	You should have received a copy of the GNU General Public License along
	with this program; if not, write to the Free Software Foundation, Inc.,
	51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

	Electrical Networks - browser version 1.0
	27 April, 2015
	opyright © 2013,2015 Harry Whitfield
	mailto:g6auc@arrl.net
*/

/*global paramOne, paramTwo, paramThree, paramFour, paramFive,
	headingOne, headingTwo, headingThree, headingFour, headingFive, clearData, Menu,
	MenuArray, theNetwork, theTable, closeBox, network_output, network
*/

/*properties
    LN10, LOG10E, background, document, exp, fixed, keyCode, lastIndexOf, length,
    log, onchange, onkeypress, onkeyup, onmousedown, onmouseup, opacity, open,
    selectedIndex, src, style, substring, title, value, which, write
*/

// map custom names onto model names
var inImpedance  = paramOne;
var outImpedance = paramTwo;
var inputPower   = paramThree;
var gain         = paramFour;
var outputPower  = paramFive;

var inImpedanceHeading  = headingOne;
var outImpedanceHeading = headingTwo;
var inputPowerHeading   = headingThree;
var gainHeading         = headingFour;
var outputPowerHeading  = headingFive;

var outputModeMenu = Menu[0];
var unitMenu       = Menu[1];

var mode = 0;	//
var unit = 0;	//

var modeValue = 0;
var oldModeValue = 0;
var unitValue = 0;

var constImp = false;
var gainEditable = true;
var gErrMess = "Invalid data";

//var modeIndex = [0, 1, 2, 3, 4, 6, 8, 9, 10, 5, 7];

var modeIndex = [0, 1, 2, 3, 4, 9, 5, 10, 6, 7, 8];

var skinPref = false;

function xtn(s) {
	var idx = s.lastIndexOf("."), ext;
	
	if (idx >= 0) {
		ext = s.substring(idx);
		if (ext.length > 7) { return ""; }
		if (ext.length > 1) { return ext; }
	}
	return "";
}

function writeFile(data) {
	var	netWindow = window.open("", "netWindow", "width=600, height=650"),
		s = "<pre>" + data + "</pre>";
		
    netWindow.document.write(s);
}

function hideNetworkWindow() {
	closeBox.style.opacity = 0;
	network_output.style.opacity = 0;
//	network_output.bgOpacity = 0;
	network.style.opacity = 0;
//	network_window.visible = false;
}

function showNetworkWindow() {
	closeBox.style.opacity = 1.0;
	network_output.style.opacity = 1.0;
//	network_output.bgOpacity = 255;
	network.style.opacity = 1.0;
//	network_window.visible = true;
}

function log10(x) { return Math.LOG10E * Math.log(x); }

function exp10(x) { return Math.exp(Math.LN10 * x); }

function formPwr(power, scale) {
	if (scale === 'dBW') {
		return (10 * log10(power)).fixed(5, 2);
	} 
	if (scale === 'dBmW') {
		return (10 * (log10(power)) + 30).fixed(5, 2);
	}
	return power.fixed(5, 2);
}

function process() {
	var result, theGain,
		rIn = parseFloat(inImpedance.value),
		rOut = parseFloat(outImpedance.value),
		power = parseFloat(inputPower.value),
		scale = MenuArray[1][unit];
	
	if (scale === 'dBW') {
		power = exp10(power / 10);
	} else if (scale === 'dBmW') {
		power = exp10((power - 30) / 10);
	}

	switch (mode) {
	case 0: // PI-Network Calculation
		theGain = parseFloat(gain.value);
		result = theNetwork(mode, rIn, rOut, power, theGain);
		if (isNaN(result)) {
			outputPower.value = gErrMess;
			hideNetworkWindow();
		} else {
			outputPower.value = '';
			if (scale !== 'watts') {
				outputPower.value += formPwr(result, scale) + ' ' + scale + ' == ';
			}
			outputPower.value += result.fixed(4, 6) + ' W';
			network.src = "Resources/PIpad.png";
			showNetworkWindow();
		}
		break;

	case 1: // PI-Network Table
		result = theTable(mode, rIn, rOut, power);
		if (result === "") {
			outputPower.value = gErrMess;
		} else {
			writeFile(result);
		}
		break;
			
	case 2: // T-Network Calculation
		theGain = parseFloat(gain.value);
		result = theNetwork(mode, rIn, rOut, power, theGain);
		if (isNaN(result)) {
			outputPower.value = gErrMess;
			hideNetworkWindow();
		} else {
			outputPower.value = '';
			if (scale !== 'watts') {
				outputPower.value += formPwr(result, scale) + ' ' + scale + ' == ';
			}
			outputPower.value += result.fixed(4, 6) + ' W';
			network.src = "Resources/Tpad.png";
			showNetworkWindow();
		}
		break;

	case 3: // T-Network Table
		result = theTable(mode, rIn, rOut, power);
		if (result === "") {
			outputPower.value = gErrMess;
		} else {
			writeFile(result);
		}
		break;

	case 4: // BT-Network Calculation
		theGain = parseFloat(gain.value);
		result = theNetwork(mode, rIn, rOut, power, theGain);
		if (isNaN(result)) {
			outputPower.value = gErrMess;
			hideNetworkWindow();
		} else {
			outputPower.value = '';
			if (scale !== 'watts') {
				outputPower.value += formPwr(result, scale) + ' ' + scale + ' == ';
			}
			outputPower.value += result.fixed(4, 6) + ' W';
			network.src = "Resources/BTpad.png";
			showNetworkWindow();
		}
		break;

	case 5: // B-Network Calculation
		theGain = parseFloat(gain.value);
		result = theNetwork(mode, rIn, rOut, power, theGain);
		if (isNaN(result)) {
			outputPower.value = gErrMess;
			hideNetworkWindow();
		} else {
			outputPower.value = '';
			if (scale !== 'watts') {
				outputPower.value += formPwr(result, scale) + ' ' + scale + ' == ';
			}
			outputPower.value += result.fixed(4, 6) + ' W';
			network.src = "Resources/Bpad.png";
			showNetworkWindow();
		}
		break;

	case 6: // L-Network Calculation
		theGain = 0;
		result = theNetwork(mode, rIn, rOut, power, theGain);
		if (isNaN(result)) {
			outputPower.value = gErrMess;
			hideNetworkWindow();
		} else {
			outputPower.value = '';
			if (scale !== 'watts') {
				outputPower.value += formPwr(result, scale) + ' ' + scale + ' == ';
			}
			outputPower.value += result.fixed(4, 6) + ' W';
			if (rIn > rOut) {
				network.src = "Resources/Lpad1.png";
			} else if (rOut > rIn) {
				network.src = "Resources/Lpad2.png";
			} else {
				network.src = "Resources/Lpad3.png";
			}
			showNetworkWindow();
		}
		break;
		
	case 7: // LS-Network Calculation
		theGain = parseFloat(gain.value);
		result = theNetwork(mode, rIn, rOut, power, theGain);
		if (isNaN(result)) {
			outputPower.value = gErrMess;
			hideNetworkWindow();
		} else {
			outputPower.value = '';
			if (scale !== 'watts') {
				outputPower.value += formPwr(result, scale) + ' ' + scale + ' == ';
			}
			outputPower.value += result.fixed(4, 6) + ' W';
			showNetworkWindow();
		}
		break;
		
	case 8: // LL-Network Calculation
		theGain = parseFloat(gain.value);
		result = theNetwork(mode, rIn, rOut, power, theGain);
		if (isNaN(result)) {
			outputPower.value = gErrMess;
			hideNetworkWindow();
		} else {
			outputPower.value = '';
			if (scale !== 'watts') {
				outputPower.value += formPwr(result, scale) + ' ' + scale + ' == ';
			}
			outputPower.value += result.fixed(4, 6) + ' W';
			showNetworkWindow();
		}
		break;
		
	case 9: // BT-Network Table
		result = theTable(mode, rIn, rOut, power);
		if (result === "") {
			outputPower.value = gErrMess;
		} else {
			writeFile(result);
		}
		break;

	case 10: // B-Network Table
		result = theTable(mode, rIn, rOut, power);
		if (result === "") {
			outputPower.value = gErrMess;
		} else {
			writeFile(result);
		}
		break;

	default:
		break;
	}
}

function updatePrefs() {
	var unitsText = "";
   
	mode = modeValue;
	unit = unitValue;
    
    unitsText = MenuArray[1][unit];
    inputPowerHeading.value = "Input Power (" + unitsText + ")";
	inputPower.title = "Input Power (" + unitsText + ").";
	
	gainEditable = (mode === 0) || (mode === 2) || (mode === 4) || (mode === 5) || (mode === 7) || (mode === 8);
	
	if (!gainEditable) {
		gain.style.background = "rgba(255 ,192, 192, 1.0)";
		gain.value = "";
	} else {
		gain.style.background = "rgba(255 ,255, 255, 1.0)";
	}

	constImp = (mode === 1) || (mode === 3) || (mode === 4) || (mode === 5) || (mode === 9) || (mode === 10);
	
	if (constImp) {
		outImpedance.style.background = "rgba(255 ,192, 192, 1.0)";
		outImpedance.value = inImpedance.value;
	} else {
		outImpedance.style.background = "rgba(255 ,255, 255, 1.0)";
	}
}

outputModeMenu.onchange  = function () {
	modeValue = modeIndex[this.selectedIndex];
	oldModeValue = modeValue;
	updatePrefs();
};

unitMenu.onchange  = function () {
	unitValue = this.selectedIndex;
	updatePrefs();
};

inImpedance.onkeypress = function (event) {
	var x = event.which || event.keyCode;
	
	if (x === 13) { process(); }
};

inImpedance.onkeyup = function () {
	if (constImp) { outImpedance.value = inImpedance.value; }
};

outImpedance.onkeypress = function (event) {
	var x = event.which || event.keyCode;
	
	if (x === 13) { process(); }
};

inputPower.onkeypress = function (event) {
	var x = event.which || event.keyCode;
	
	if (x === 13) { process(); }
};

gain.onkeypress = function (event) {
	var x = event.which || event.keyCode;
	
	if (x === 13) { process(); }
};

closeBox.onmousedown = function () { this.style.opacity = "0.5"; };
closeBox.onmouseup   = function () { hideNetworkWindow(); };

//updatePrefs();
