/*
    Cookies
    Copyright © 2016 Harry Whitfield

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License as
    published by the Free Software Foundation; either version 2 of
    the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public
    License along with this program; if not, write to the Free
    Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston,
    MA  02110-1301  USA

    Cookies - browser version 1.4
    7 July, 2016
    Copyright © 2016 Harry Whitfield
    mailto:g6auc@arrl.net
*/

/*jslint browser, devel, multivar */

/*property
    cookie, cookieEnabled, getTime, indexOf, length, replace, setTime, split,
    substring, toUTCString
*/

///////////////////////////////////////// cookies ////////////////////////////////////////

var permitCookies = false;

function setCookie(name, value, days, prefix) {
    "use strict";
	var date, expires = "", path = "", cookie;

	if (navigator.cookieEnabled && permitCookies) {
		if (days) {
			date = new Date();
			date.setTime(date.getTime() + 86400000 * days);
			expires = "; expires=" + date.toUTCString();
			if (prefix) {
				path = "; path=" + prefix;
			}
		}
		cookie = name + "=" + encodeURIComponent(value) + expires + path;
		document.cookie = cookie;
	}
}

function getCookie(name) {
    "use strict";
	var lookFor = name + "=", cookies = document.cookie.split(";"), i, cookie;

	i = 0;
	while (i < cookies.length) {
		cookie = cookies[i].replace(/^\s+|\s+$/g, "");
		if (cookie.indexOf(lookFor) === 0) {
			return decodeURIComponent(cookie.substring(lookFor.length));
		}
		i += 1;
	}
	return "";
}

function deleteCookie(name) {
    "use strict";
	setCookie(name, encodeURIComponent(name), -1);
}

function cookiesPermitted() {
    "use strict";
	if (navigator.cookieEnabled && !permitCookies) {
    	permitCookies = confirm("This site can use cookies (small text files stored on your phone " +
    			"or computer by your browser) to remember the options you last used, " +
    			"so that the same options can be selected when you next access the site.\n" +
    			"For example, the Phone Book entries are stored in a cookie.\n\n" +
    			"Click OK to permit this, or click Cancel to refuse permission.");
	}
	return navigator.cookieEnabled && permitCookies;
}

function setPreference(key, value) {
    "use strict";
	setCookie("Pref-" + key, value, 90);
}

function getPreference(key) {
    "use strict";
	return getCookie("Pref-" + key);
}

//////////////////////////////////////////////////////////////////////////////////////////