/*
    dropfile code by hw
    Provides a drag and drop capability for javascript and json files onto the source textarea.
    Uses HTML5 File APIs if available.
*/

/*jslint
    browser
*/

/*global File, FileReader, FileList, Blob, alert, logData, user_name */

/*property
    addEventListener, dataTransfer, dropEffect, files, match, name, onload,
    preventDefault, readAsText, result, stopPropagation, type, value
*/

(function (textArea, filename) {
    "use strict";
//    var textArea = document.getElementById(textAreaId);
//    var filename = document.getElementById(filenameId);

    function readText(file, callback) {
        var reader = new FileReader();

        reader.onload = function () {
            callback(reader.result);
        };
        reader.readAsText(file);
    }

    function handleDrop(evt) {
        var files;
        var file;

        evt.stopPropagation();
        evt.preventDefault();

        files = evt.dataTransfer.files;
        file = files[0];

        if (file.type.match(/^application\/(x-)?(java|ecma)script/) ||
                file.type.match(/^application\/json/) ||
                file.type.match(/^text\/((x-)?(java|ecma)|live|j)script/) ||
                file.type.match(/^text\/plain/)) {
            readText(file, function (text) {
                textArea.value = text;
            });
            filename.value = file.name;
        } else {
            alert("Invalid file type: " + file.type);
        }
    }

    function handleDragOver(evt) {
        evt.stopPropagation();
        evt.preventDefault();
        evt.dataTransfer.dropEffect = "copy";
    }

    if (File && FileReader && FileList && Blob) {
        textArea.addEventListener("dragover", handleDragOver, false);
        textArea.addEventListener("drop", handleDrop, false);
    } else {
        alert("File APIs are missing.");
    }

}(logData, user_name));
