/*
    DTMF Dial
   	Copyright 2004-2016 Harry Whitfield

    This program is free software; you can redistribute it and/or modify it under
    the terms of the GNU General Public License as published by the Free Software
    Foundation; either version 2 of the License, or (at your option) any later
    version.

    This program is distributed in the hope that it will be useful, but WITHOUT ANY
    WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
    PARTICULAR PURPOSE.  See the GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along with
    this program; if not, write to the Free Software Foundation, Inc., 51 Franklin
    St, Fifth Floor, Boston, MA  02110-1301  USA

    DTMF Dial - browser version 1.0
    16 July, 2016
    Copyright 2004-2016 Harry Whitfield
    mailto:g6auc@arrl.net
*/

/*jslint browser, multivar, this */

/*global newImage, newInput, newText, alert, window, playSound, eprint,
	mapString, convert, longtonePref, setPreference, logData, selectPane,
	play, map
*/

/*property
    altKey, checked, forEach, index, indexOf, innerHTML, keyCode, length,
    onkeypress, onmousedown, onmouseup, opacity, open, push, shiftKey, style,
    substring, title, value, which
*/

////////////////////////////////// Start of the dtmf gui /////////////////////////////////

//  mainWindow.width = Math.round(scale * 870);	// was 320
//  mainWindow.height = Math.round(scale * 300);

// newImage(hOffset, vOffset, width, height, src, zOrder, opacity)
// newText(hOffset, vOffset, width, height, value, zOrder, style)
// newTextArea(hOffset, vOffset, cols, rows, value, zOrder, style)
// newInput(hOffset, vOffset, width, height, value, zOrder, style)
// newCanvas(hOffset, vOffset, width, height, src, zOrder, opacity, hRegP, vRegP)
// newSelector(hOffset, vOffset, width, height, src, zOrder, opacity)

var menuPref;
var menuCode;
var alfaprocPref;
var alfaprocCode;
var numprocPref;
var numprocCode;
var rBuffer;
var kBuffer;

var key = [];
var base = "Resources/Images/";

var phoneBookMenu = newImage(168, 0, 80, 22, base + "quickList.png", 1, 1.0);

var background1 = newImage(0, 168, 154, 28, base + "bg.png", 1, 1.0);
var background2 = newImage(0, 200, 154, 28, base + "bg.png", 1, 1.0);

var style = "font-family:Arial;font-size:14px;color:black;background-color:transparent;border:none;";

var user_name = newInput(0, 168, 110, 20, "", 2, style);
user_name.title = "Username - for later use.";
var telephone = newInput(0, 200, 110, 20, "", 2, style);
telephone.title = "Enter a telephone number, then press RETURN or click on the green telephone button.";

base = "Resources/Images/Keys/";

var phone = newImage(0, 232, 28, 28, base + "phone.png", 2, 1.0);
var backspace = newImage(42, 232, 28, 28, base + "BS.png", 2, 1.0);
var clear = newImage(84, 232, 28, 28, base + "CLR.png", 2, 1.0);
var hangup = newImage(126, 232, 28, 28, base + "hangup.png", 2, 1.0);

phone.title = "Click to play the number.\n" +
		"Alt-click to toggle the Phone Book Menu.\n" +
		"Shift+alt-click to toggle Alphabetic Processing.\n" +
		"Shift-click to toggle Number Processing.";
clear.title = "CLEAR";
hangup.title = "HANG-UP";

function beep() {
    "use strict";
    alert("Invalid Input");
}

function setOpacity255() {
    "use strict";
    this.style.opacity = 1.0;
}

var intervalID = null;

function dtmfDial(s) {
    "use strict";
	var d,
		t,
		timeout,
		delay,
		good = ",0123456789ABCD*#",
		tick = function () {
			dtmfDial(t);
		};

	if (s === "") {
		return;
	}

	delay = (longtonePref === "0")
		? 150
		: 350;

	d = good.indexOf(s[0]);
	if (d >= 0) {
		t = s.substring(1);
		timeout = (d === 16)
			? 1000
			: delay;
		if (t !== "") {
			intervalID = setTimeout(tick, timeout);
		}
		if (d !== 16) {
			playSound(d);
		}
	}
}

function toggleMenu() {
    "use strict";
	menuPref = (menuPref === "0")
		? "1"
		: "0";
	phoneBookMenu.style.opacity = menuPref;
	setPreference("menuPref", menuPref);
	menuCode.checked = (menuPref === "1");
}

function phoneAction(event) {
    "use strict";
	var s,
		t,
		tick = function () {
			play(t);
		};

	if (event.shiftKey && event.altKey) {
		alfaprocPref = (alfaprocPref === "0")
			? "1"
			: "0";
		setPreference("alfaprocPref", alfaprocPref);
		alfaprocCode.checked = (alfaprocPref === "1");
		if (alfaprocPref === "0") {
			t = rBuffer;
			setTimeout(tick, 1000);
			play(rBuffer);
		} else {
			t = kBuffer;
			setTimeout(tick, 1000);
			play(kBuffer);
		}
		return;
	}
	if (event.shiftKey) {
		numprocPref = (numprocPref === "0")
			? "1"
			: "0";
		setPreference("numprocPref", numprocPref);
		numprocCode.checked = (numprocPref === "1");
		if (numprocPref === "0") {
			play(rBuffer);
		} else {
			play(kBuffer);
		}
		return;
	}
	if (event.altKey) {
		toggleMenu();
		return;
	}

	s = telephone.value;
	if (s === "") {
		return;
	}

	eprint("--- phoneAction ----");
	eprint("Original Number   " + s);

	if (alfaprocPref === "1") {
		s = mapString(s);
		eprint("Mapped Number	  " + s);
	}

	if (numprocPref === "1") {
		s = convert(s);
		eprint("Converted Number  " + s);
	}
	dtmfDial(s);
}

phone.onmouseup = setOpacity255;
phone.onmousedown = function (event) {
    "use strict";
    this.style.opacity = 0.5;
	phoneAction(event);
};

backspace.onmouseup = setOpacity255;
backspace.onmousedown = function () {
    "use strict";
    this.style.opacity = 0.5;
    if (telephone.value !== "") {
        telephone.value = telephone.value.substring(0, telephone.value.length - 1);
    }
	user_name.innerHTML = "";
};

clear.onmouseup = setOpacity255;
clear.onmousedown = function () {
    "use strict";
    this.style.opacity = 0.5;
    telephone.value = "";
	user_name.innerHTML = "";
};

hangup.onmouseup = setOpacity255;
hangup.onmousedown = function () {
    "use strict";
    this.style.opacity = 0.5;
//	phoneHangUp();
//	window.close();
};

telephone.onkeypress = function (event) {
    "use strict";
	var x = event.which || event.keyCode;

	if (x === 13) {
	    phoneAction(event);
	}
};

function process(event) {// handles keys 0 to 15
    "use strict";
    var i = this.index;
    var s = "0123456789ABCD*#";
    var mapi = [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 2, 2, 2, 3, 14, 15];

    this.style.opacity = 0.5;

    if ((event.altKey) && (i > 9) && (i < 14)) {
		eprint("key " + s[i] + " pressed.");
		return;
    }

    telephone.value += map(s[i]);

	if (alfaprocPref !== "0") {
		i = mapi[i];
	}
    playSound(i);
}

//////////////////////////////////////////////////////////////////////////////////////////

function makeKeys() { //creates the images for keys 0 to 9, star and hash, and A to D
    "use strict";
    var coords = [[42, 126], [0, 0], [42, 0], [84, 0], [0, 42], [42, 42], [84, 42], [0, 84], [42, 84], [84, 84]];
    var coord2 = [[0, 126], [84, 126], [126, 0], [126, 42], [126, 84], [126, 126]];
    var image2 = ["star", "hash", "A", "B", "C", "D"];
    var index2 = [14, 15, 10, 11, 12, 13];
    var ttips2 = ["*", "#", "A", "B", "C", "D"];

    function doThis(coord, i) {
        var img = newImage(coord[0], coord[1], 28, 28, base + String(i) + ".png", 1, 1.0);
        img.index = i;
        img.onmouseup = setOpacity255;
        img.onmousedown = process;
        img.title = "Dial " + String(i);
        key.push(img);
    }

	function doThat(coord, i) {
        var img = newImage(coord[0], coord[1], 28, 28, base + image2[i] + ".png", 1, 1.0);
        img.index = index2[i];
        img.onmouseup = setOpacity255;
        img.onmousedown = process;
        img.title = "Dial " + ttips2[i];
        key.push(img);
    }

    coords.forEach(doThis);
    coord2.forEach(doThat);
}

makeKeys();

//////////////////////////////////////////////////////////////////////////////////////////

base = "Resources/Images/";

var helpButton = newImage(246, 0, 30, 22, base + "help.png", 2);   // customized
helpButton.title = "Displays information about this program.";
helpButton.onmousedown = function () {
    "use strict";
    this.style.opacity = "0.5";
};
helpButton.onmouseup = function () {
    "use strict";
    this.style.opacity = "1.0";
    window.open("Help.html");
};

var panes = ["none", "general", "options", "window"];
var panePref = 0;

var star = newImage(275, 2, 18, 18, base + "prefs.png", 2, 1.0);
star.title = "Show or hide preferences.\nAlt-click to show or hide the log window.";

star.onmouseup = function (event) {
    "use strict";
    if (event.altKey) {
    	logData.style.opacity = 1.0 - logData.style.opacity;
    } else if (panePref !== 0) {
		panePref = 0;
		selectPane(panes[0]);
	} else {
		panePref = 1;
		selectPane(panes[1]);
	}
};
