/*
    DTMF Dial
   	Copyright 2004-2016 Harry Whitfield

    This program is free software; you can redistribute it and/or modify it under
    the terms of the GNU General Public License as published by the Free Software
    Foundation; either version 2 of the License, or (at your option) any later
    version.

    This program is distributed in the hope that it will be useful, but WITHOUT ANY
    WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
    PARTICULAR PURPOSE.  See the GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along with
    this program; if not, write to the Free Software Foundation, Inc., 51 Franklin
    St, Fifth Floor, Boston, MA  02110-1301  USA

    DTMF Dial - browser version 1.1
    23 July, 2016
    Copyright 2004-2016 Harry Whitfield
    mailto:g6auc@arrl.net
*/

/*jslint browser, multivar, this */

/*global newImage, newInput, newText, alert, window, playSound, eprint,
	mapString, convert, longtonePref, setPreference, logData, selectPane,
	play, map, newSelector, addToMenu, removeFromMenu, clearLog, getLogData,
	getURL
*/

/*property
    altKey, checked, close, forEach, index, indexOf, join, keyCode, length,
    onchange, onclick, onkeypress, onmousedown, onmouseup, opacity, open,
    parse, push, replace, selectedIndex, setAttribute, shiftKey, some, sort,
    split, stringify, style, substring, title, value, which
*/

////////////////////////////////// Start of the dtmf gui /////////////////////////////////

//  mainWindow.width = Math.round(scale * 870);	// was 320
//  mainWindow.height = Math.round(scale * 300);

// newImage(hOffset, vOffset, width, height, src, zOrder, opacity)
// newText(hOffset, vOffset, width, height, value, zOrder, style)
// newTextArea(hOffset, vOffset, cols, rows, value, zOrder, style)
// newInput(hOffset, vOffset, width, height, value, zOrder, style)
// newCanvas(hOffset, vOffset, width, height, src, zOrder, opacity, hRegP, vRegP)
// newSelector(hOffset, vOffset, width, height, src, zOrder, opacity)

var menuPref;
var menuCode;
var alfaprocPref;
var alfaprocCode;
var numprocPref;
var numprocCode;
var rBuffer;
var kBuffer;

var key = [];
var intervalID = null;

var help_y0 = 200;
var star_y0 = 202;
var buttons_y0 = 200;
var altshift_y0 = 0;

var base = "Resources/Images/";
var background1 = newImage(0, 168, 154, 28, base + "bg.png", 1, 1.0);
var background2 = newImage(0, 242, 320, 28, base + "bg.png", 1, 1.0);

var style = "font-family:Arial;font-size:14px;color:black;background-color:transparent;border:none;";

var telephone = newInput(0, 167, 116, 20, "", 2, style);
telephone.title = "Telephone Number Field: Enter a telephone number, then press RETURN or click on the green telephone button.";

base = "Resources/Images/Keys/";

var phone = newImage(0, buttons_y0, 28, 28, base + "phone.png", 2, 1.0);
var backspace = newImage(42, buttons_y0, 28, 28, base + "BS.png", 2, 1.0);
var clear = newImage(84, buttons_y0, 28, 28, base + "CLR.png", 2, 1.0);
var hangup = newImage(126, buttons_y0, 28, 28, base + "hangup.png", 2, 1.0);

phone.title = "Click to play the number.\n" +
		"Alt-click to toggle the Phone Book Menu.\n" +
		"Shift+alt-click to toggle Alphabetic Processing.\n" +
		"Shift-click to toggle Number Processing.";
backspace.title = "BACKSPACE";
clear.title = "CLEAR";
hangup.title = "CLOSE";

var user_name = newInput(0, 241, 256, 20, "", 2, style);
user_name.title = "Name field: Enter the name to be associated with the telephone number.";

//////////////////////////////////// Phone Book Menu /////////////////////////////////////

var phoneBookMenu = newSelector(0, 282, 300, 20, "", 20);
phoneBookMenu.title = "Choose a phone number.";

function setMenu(phoneBookMenu, menuStrings, value) {
    "use strict";
    addToMenu(phoneBookMenu, menuStrings);
    phoneBookMenu.value = value;
}

//////////////////////////////////////// Alt-Key /////////////////////////////////////////

var altKey = newInput(307, altshift_y0, 8, 16, "alt-key", 3);
altKey.setAttribute("type", "checkbox");

var altButton = newInput(249, altshift_y0, 8, 16, "alt-key", 3);
altButton.setAttribute("type", "button");

altButton.onclick = function () {
    "use strict";
    altKey.checked = !altKey.checked;
};

/////////////////////////////////////// Shift-Key ////////////////////////////////////////

var shiftKey = newInput(227, altshift_y0, 8, 16, "shift-key", 3);
shiftKey.setAttribute("type", "checkbox");

var shiftButton = newInput(158, altshift_y0, 8, 16, "shift-key", 3);
shiftButton.setAttribute("type", "button");

shiftButton.onclick = function () {
    "use strict";
    shiftKey.checked = !shiftKey.checked;
};


//////////////////////////////////////////////////////////////////////////////////////////

function beep() {
    "use strict";
    alert("Invalid Input");
}

function setOpacity255() {
    "use strict";
    this.style.opacity = 1.0;
}

function dtmfDial(s) {
    "use strict";
	var d,
		t,
		timeout,
		delay,
		good = ",0123456789ABCD*#",
		tick = function () {
			dtmfDial(t);
		};

	if (s === "") {
		return;
	}

	delay = (longtonePref === "0")
		? 150
		: 350;

	d = good.indexOf(s[0]);
	if (d >= 0) {
		t = s.substring(1);
		timeout = (d === 16)
			? 1000
			: delay;
		if (t !== "") {
			intervalID = setTimeout(tick, timeout);
		}
		if (d !== 16) {
			playSound(d);
		}
	}
}

function toggleMenu() {
    "use strict";
	menuPref = (menuPref === "0")
		? "1"
		: "0";
	phoneBookMenu.style.opacity = menuPref;
	setPreference("menuPref", menuPref);
	menuCode.checked = (menuPref === "1");
}

function phoneAction(event) {
    "use strict";
	var n,
		s,
		t,
		tick = function () {
			play(t);
		};

	if ((shiftKey.checked || event.shiftKey) && (altKey.checked || event.altKey)) {
		alfaprocPref = (alfaprocPref === "0")
			? "1"
			: "0";
		setPreference("alfaprocPref", alfaprocPref);
		alfaprocCode.checked = (alfaprocPref === "1");
		if (alfaprocPref === "0") {
			t = rBuffer;
			setTimeout(tick, 1000);
			play(rBuffer);
		} else {
			t = kBuffer;
			setTimeout(tick, 1000);
			play(kBuffer);
		}
		return;
	}
	if (shiftKey.checked || event.shiftKey) {
		numprocPref = (numprocPref === "0")
			? "1"
			: "0";
		setPreference("numprocPref", numprocPref);
		numprocCode.checked = (numprocPref === "1");
		if (numprocPref === "0") {
			play(rBuffer);
		} else {
			play(kBuffer);
		}
		return;
	}
	if (altKey.checked || event.altKey) {
		toggleMenu();
		return;
	}

	s = telephone.value;
	if (s === "") {
		return;
	}
	n = user_name.value;

	eprint("--- " + n + " ----");
	eprint("Original Number   " + s);

	if (alfaprocPref === "1") {
		s = mapString(s);
		eprint("Mapped Number	  " + s);
	}

	if (numprocPref === "1") {
		s = convert(s);
		eprint("Converted Number  " + s);
	}
	dtmfDial(s);
}

phone.onmouseup = setOpacity255;
phone.onmousedown = function (event) {
    "use strict";
    this.style.opacity = 0.5;
	phoneAction(event);
};

backspace.onmouseup = setOpacity255;
backspace.onmousedown = function () {
    "use strict";
    this.style.opacity = 0.5;
    if (telephone.value !== "") {
        telephone.value = telephone.value.substring(0, telephone.value.length - 1);
    }
	user_name.value = "";
};

clear.onmouseup = setOpacity255;
clear.onmousedown = function () {
    "use strict";
    this.style.opacity = 0.5;
    telephone.value = "";
	user_name.value = "";
};

function callback(data) {
    "use strict";
	if (data) {
		eprint(data);
	}
}

hangup.onmouseup = setOpacity255;
hangup.onmousedown = function (event) {
    "use strict";
    this.style.opacity = 0.5;
    if ((shiftKey.checked || event.shiftKey) && (altKey.checked || event.altKey)) {
		getURL("http://g6auc.me.uk/DTMF_Dial/zzzz/Phone_Book.json", 5, "", callback);
    } else {
		window.close();
	}
};

telephone.onkeypress = function (event) {
    "use strict";
	var x = event.which || event.keyCode;

	if (x === 13) {
	    phoneAction(event);
	}
};

/////////////////////////////////////// Phone Book ///////////////////////////////////////

var savedDirPref;
var savedDefaultPref;
var phoneDir;
var phoneDefault;
var phoneNum;
var dirString;

function conflateDir(phoneDir) {
	"use strict";
	var result = [];

	phoneDir.forEach(function (ele) {
		if (ele !== "") {
		    result.push(ele);
		}
	});
	return result;
}

function findNumber(phoneDir, phoneNum) {
	"use strict";
	var i;

	return (phoneDir.some(function (ele, idx) {
		i = idx;
		return ele === phoneNum;
	}))
	    ? i
	    : -1;
}

function printDirectory(phoneDir, phoneNum) {
	"use strict";
	eprint("------------Directory------------");
	phoneDir.forEach(function (ele) {
	    if (ele !== "") {
	        eprint(ele);
	    }
	});
	eprint("-------------Default-------------");
	eprint(phoneNum);
}

function stripMinusAndComma(theNumber) {
	"use strict";
	// remove all minus and comma characters, converts comma to colon
	var temp = "";

	theNumber.split("").forEach(function (ele) {
		if (ele === ",") {
			temp += ":";
		} else if (ele !== "-") {
		    temp += ele;
		}
    });
	return temp;
}

function extractNum(phoneNum) {
	"use strict";
	// Emergency - 911
	var idx = phoneNum.indexOf("-");

	return phoneNum.substring(idx + 2)
		.replace(/\:/g, ",");
}

function extractName(phoneNum) {
	"use strict";
	// Emergency - 911
	var idx = phoneNum.indexOf("-");

	return phoneNum.substring(0, idx - 1)
		.replace(/\:/g, ",");
//		.replace(/^\./, "");
}

function initPhoneBook() {
    "use strict";
	phoneDir = savedDirPref.split(",");
	phoneDir = conflateDir(phoneDir);
	phoneDir = phoneDir.sort();
	savedDirPref = phoneDir.join(",");
	phoneDefault = savedDefaultPref;
	phoneNum = phoneDefault;
	printDirectory(phoneDir, phoneDefault);
	telephone.value = extractNum(phoneNum);
	user_name.value = extractName(phoneNum);

    setPreference("savedDirPref", savedDirPref);
    setPreference("savedDefaultPref", savedDefaultPref);

	dirString = "Phone Book";
	if (savedDirPref !== "") {
		dirString = "Phone Book\n" + savedDirPref.replace(/,/g, "\n").replace(/\:/g, ",");
		setMenu(phoneBookMenu, dirString.split("\n"), phoneDefault || "Phone Book");
	} else {
		setMenu(phoneBookMenu, ["Phone Book"], "Phone Book");
	}
}

phoneBookMenu.onchange = function () {
	"use strict";
	if (phoneBookMenu.selectedIndex !== 0) {
		telephone.value = extractNum(phoneBookMenu.value);
		user_name.value = extractName(phoneBookMenu.value);
		savedDefaultPref = phoneBookMenu.value;
		setPreference("savedDefaultPref", savedDefaultPref);
	}
};

function getPhoneNumber() {
	"use strict";
	var phoneName = stripMinusAndComma(user_name.value);
	var phoneNumber = stripMinusAndComma(telephone.value);
	var result;

	if ((phoneName !== "") && (phoneNumber !== "")) {
		result = phoneName + " - " + phoneNumber;
	} else {
		result = "";
		alert("The data entered was incomplete and has been ignored.");
	}
	eprint("getPhoneNumber=" + result);
	return result;
}

function keyA() {
	"use strict";
	phoneNum = getPhoneNumber();
	if (phoneNum !== "") {
        addToMenu(phoneBookMenu, [phoneNum], phoneNum);
        phoneBookMenu.value = phoneNum;
		telephone.value = extractNum(phoneNum);
		user_name.value = extractName(phoneNum);
		phoneDefault = phoneNum;
		phoneDir.push(phoneNum);
		printDirectory(phoneDir, phoneDefault);
		savedDirPref = phoneDir.join(",");
		savedDefaultPref = phoneDefault;
    	setPreference("savedDirPref", savedDirPref);
    	setPreference("savedDefaultPref", savedDefaultPref);
    	setTimeout("location.reload(true);", 1000);
	}
}

function keyB() {
	"use strict";
	var data = getLogData();

	if (data !== "") {
		phoneDir = JSON.parse(data);
		phoneDefault = "";
		phoneBookMenu.selectedIndex = 0;
		savedDirPref = phoneDir.join(",");
		savedDefaultPref = phoneDefault;
    	setPreference("savedDirPref", savedDirPref);
    	setPreference("savedDefaultPref", savedDefaultPref);
    	setTimeout("location.reload(true);", 1000);
	}
}

function keyC(shift_key) {
	"use strict";
	clearLog();
	if (shift_key) {
		return;
	}
	eprint(JSON.stringify(phoneDir));
}

function keyD() {
	"use strict";
	var index;

	phoneNum = getPhoneNumber();
	if (phoneNum !== "") {
		index = findNumber(phoneDir, phoneNum);
		eprint("index: " + index);
		if (index >= 0) {
			removeFromMenu(phoneBookMenu, index + 1);
			phoneDir[index] = "";
			phoneDir = conflateDir(phoneDir);
			phoneDefault = "";
			phoneBookMenu.selectedIndex = 0;
			printDirectory(phoneDir, phoneDefault);
			savedDirPref = phoneDir.join(",");
			savedDefaultPref = phoneDefault;
    		setPreference("savedDirPref", savedDirPref);
    		setPreference("savedDefaultPref", savedDefaultPref);
		}
	}
}

function process(event) {// handles keys 0 to 15
    "use strict";
    var i = this.index;
    var s = "0123456789ABCD*#";
    var mapi = [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 2, 2, 2, 3, 14, 15];
    var alt_key = altKey.checked || event.altKey;
    var shift_key = shiftKey.checked || event.shiftKey;

    this.style.opacity = 0.5;

    if (alt_key && (i > 9) && (i < 14)) {
//		eprint("key " + s[i] + " pressed.");
		switch (s[i]) {
		case "A":
			keyA();
			break;
		case "B":
			keyB();
			break;
		case "C":
			keyC(shift_key);
			break;
		case "D":
			keyD();
			break;
		}
		return;
    }

    telephone.value += map(s[i]);

	if (alfaprocPref !== "0") {
		i = mapi[i];
	}
    playSound(i);
}

//////////////////////////////////////////////////////////////////////////////////////////

base = "Resources/Images/Keys/";

function makeKeys() { //creates the images for keys 0 to 9, star and hash, and A to D
    "use strict";
    var coords = [[42, 126], [0, 0], [42, 0], [84, 0], [0, 42], [42, 42], [84, 42], [0, 84], [42, 84], [84, 84]];
    var coord2 = [[0, 126], [84, 126], [126, 0], [126, 42], [126, 84], [126, 126]];
    var image2 = ["star", "hash", "A", "B", "C", "D"];
    var index2 = [14, 15, 10, 11, 12, 13];
    var ttips2 = ["*", "#", "A(2)", "B(2)", "C(2)", "D(3)"];
    ttips2[2] += "\nAlt-click to add a Phone Book entry.";
    ttips2[3] += "\nAlt-click to load the Phone Book from the log window.";
    ttips2[4] += "\nAlt-click to copy the Phone Book to the log window." +
    		"\nShift+alt-click to clear the log window.";
    ttips2[5] += "\nAlt-click to delete a Phone Book entry.";

    function doThis(coord, i) {
        var img = newImage(coord[0], coord[1], 28, 28, base + String(i) + ".png", 1, 1.0);
        img.index = i;
        img.onmouseup = setOpacity255;
        img.onmousedown = process;
        img.title = "Dial " + String(i);
        key.push(img);
    }

	function doThat(coord, i) {
        var img = newImage(coord[0], coord[1], 28, 28, base + image2[i] + ".png", 1, 1.0);
        img.index = index2[i];
        img.onmouseup = setOpacity255;
        img.onmousedown = process;
        img.title = "Dial " + ttips2[i];
        key.push(img);
    }

    coords.forEach(doThis);
    coord2.forEach(doThat);
}

makeKeys();

//////////////////////////////////////////////////////////////////////////////////////////

base = "Resources/Images/";

var helpButton = newImage(266, help_y0, 30, 22, base + "help.png", 2);   // customized
helpButton.title = "Displays information about this program.";
helpButton.onmousedown = function () {
    "use strict";
    this.style.opacity = "0.5";
};
helpButton.onmouseup = function () {
    "use strict";
    this.style.opacity = "1.0";
    window.open("Help.html");
};

var panes = ["none", "general", "options", "window"];
var panePref = 0;

var star = newImage(305, star_y0, 18, 18, base + "prefs.png", 2, 1.0);
star.title = "Show or hide preferences.\nAlt-click to show or hide the log window.";

star.onmouseup = function (event) {
    "use strict";
    if (altKey.checked || event.altKey) {
    	logData.style.opacity = 1.0 - logData.style.opacity;
    } else if (panePref !== 0) {
		panePref = 0;
		selectPane(panes[0]);
	} else {
		panePref = 1;
		selectPane(panes[1]);
	}
};

//////////////////////////////////////////////////////////////////////////////////////////

