/*
    DTMF Dial
   	Copyright 2004-2016 Harry Whitfield

    This program is free software; you can redistribute it and/or modify it under
    the terms of the GNU General Public License as published by the Free Software
    Foundation; either version 2 of the License, or (at your option) any later
    version.

    This program is distributed in the hope that it will be useful, but WITHOUT ANY
    WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
    PARTICULAR PURPOSE.  See the GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along with
    this program; if not, write to the Free Software Foundation, Inc., 51 Franklin
    St, Fifth Floor, Boston, MA  02110-1301  USA

    DTMF Dial - browser version 1.0
    16 July, 2016
    Copyright 2004-2016 Harry Whitfield
    mailto:g6auc@arrl.net
*/

/*jslint browser */

/*global getPreference, phoneBookMenu */

/*property
    checked, cookieEnabled, opacity, style, value
*/

///////////////////////////////////// Preference Code ////////////////////////////////////

var countryPref = "44";
var areaPref = "1422";
var digitsPref = "6";
var internationalPref = "00";
var nationalPref = "0";
var prefixPref = "";
var allowPref = "1";

var menuPref = "1";
var alfaprocPref = "1";
var numprocPref = "1";
var longtonePref = "0";

var countryCode;
var areaCode;
var digitsCode;
var internationalCode;
var nationalCode;
var prefixCode;
var allowCode;

var menuCode;
var alfaprocCode;
var numprocCode;
var longtoneCode;

var savedDirPref = "";
var savedDefaultPref = "";

//////////////////////////////////////////////////////////////////////////////////////////

var permitCookies;

function getPreferences() {
    "use strict";
	var pref;

    if (navigator.cookieEnabled) {
    	pref = getPreference("countryPref");
        if (pref !== "") {
         	countryPref = pref;
         	countryCode.value = pref;
         	permitCookies = true;
        }
     	pref = getPreference("areaPref");
        if (pref !== "") {
         	areaPref = pref;
          	areaCode.value = pref;
        	permitCookies = true;
        }
    	pref = getPreference("digitsPref");
        if (pref !== "") {
         	digitsPref = pref;
         	digitsCode.value = pref;
         	permitCookies = true;
        }
    	pref = getPreference("internationalPref");
        if (pref !== "") {
         	internationalPref = pref;
         	internationalCode.value = pref;
         	permitCookies = true;
        }
    	pref = getPreference("nationalPref");
        if (pref !== "") {
         	nationalPref = pref;
         	nationalCode.value = pref;
         	permitCookies = true;
        }
    	pref = getPreference("prefixPref");
        if (pref !== "") {
         	prefixPref = pref;
         	prefixCode.value = pref;
         	permitCookies = true;
        }
    	pref = getPreference("allowPref");
        if (pref !== "") {
         	allowPref = pref;
          	allowCode.checked = (pref === "1");
        	permitCookies = true;
        }

     	pref = getPreference("menuPref");
        if (pref !== "") {
         	menuPref = pref;
			menuCode.checked = (pref === "1");
			phoneBookMenu.style.opacity = menuPref;
        	permitCookies = true;
        }
     	pref = getPreference("alfaprocPref");
        if (pref !== "") {
         	alfaprocPref = pref;
			alfaprocCode.checked = (pref === "1");
        	permitCookies = true;
        }
    	pref = getPreference("numprocPref");
        if (pref !== "") {
         	numprocPref = pref;
			numprocCode.checked = (pref === "1");
         	permitCookies = true;
        }
    	pref = getPreference("longtonePref");
        if (pref !== "") {
         	longtonePref = pref;
			longtoneCode.checked = (pref === "1");
         	permitCookies = true;
        }
    	pref = getPreference("savedDirPref");
        if (pref !== "") {
         	savedDirPref = pref;
         	permitCookies = true;
        }
    	pref = getPreference("savedDefaultPref");
        if (pref !== "") {
         	savedDefaultPref = pref;
         	permitCookies = true;
        }
	}
}

//////////////////////////////////////////////////////////////////////////////////////////
