/*jslint browser, this */

/*global ActiveXObject, window, eprint */

/*property
    XMLHttpRequest, getAllResponseHeaders, join, onreadystatechange, open,
    readyState, responseText, send, sort, split, status, timeout
*/

function getURL(url, timeout, ignore, callback) {	// timeout in seconds
	"use strict";

	var request;
	var myStatusProc;

	if (window.XMLHttpRequest) {
		request = new XMLHttpRequest();
	} else {
	    // code for IE6, IE5
    	request = new ActiveXObject("Microsoft.XMLHTTP");
	}

	myStatusProc = function () {
		var title = "=== ResponseHeaders ===";
		var arr;

		if (this.readyState === 4) {
			if (request.status === 200) {
				arr = request.getAllResponseHeaders().split(/\r\n?|\n/).sort();
				if (arr[0] === "") {
					arr[0] = title;
					eprint(arr.join("\n"));
				} else {
					eprint(title + "\n" + arr.join("\n"));
				}
				callback(request.responseText);
			} else {
				callback(null);
			}
		}
	};

	request.onreadystatechange = myStatusProc;
	request.open("GET", url, true);
	request.timeout = 1000 * timeout;
	request.send();
}
