/*jslint browser, devel, multivar */

/*global newTextArea, require */

/*property
    appendFileSync, encoding, getDate, getFullYear, getHours, getMilliseconds,
    getMinutes, getMonth, getSeconds, join, length, platform, readFile,
    readFileSync, split, title, toString, value, writeFile, writeFileSync
*/

// optionally set up an in-browser log textarea
var style0 = "font-family:Courier;color:black;font-weight:normal;background-color:white;border:solid 1px black;font-size:13px;opacity: 0.0";
var logData = newTextArea(330, 0, 70, 12, "", 25, style0);
logData.title = "For log data.";

// specify the log file
var logFile = "/Users/nhw/Desktop/dtmf_dial.log";

// check for availability of filesystem functions in node.js
var hasFs = typeof require === "function" && require("fs") !== undefined;

// define the filesystem function
var filesystem = {};
if (hasFs) {
	filesystem = (function () {
		"use strict";
		var itself = {};
		var fs = require("fs");
		var os = require("os");
		var system = {};

		system.platform = (os.platform() === "darwin")
			? "macintosh"
			: "windows";

		itself.readFile = function (path, asLines) {
	    	var text = fs.readFileSync(path, {encoding: "utf8"});

	 		return (asLines)
	 			? text.split(/\r\n?|\n/)
	 			: text;
		};

		itself.writeFile = function (path, text, append) {
			if (typeof text === "string") {
				text = text.split(/\r\n?|\n/);
			}
			text = (system.platform === "macintosh")
				? text.join("\n")
				: text.join("\r\n");

			if (append) {
				fs.appendFileSync(path, text, {encoding: "utf8"});
			} else {
				fs.writeFileSync(path, text, {encoding: "utf8"});
			}
		};

		return itself;
	}());
}

function clearLog() {
	"use strict";
	logData.value = "";
}

function getLogData() {
	"use strict";
	return logData.value;
}

function writeLog() {
	"use strict";
	var path;

	if (hasFs) {
		path = prompt("Enter the path for the file: ", "/Users/nhw/Desktop/log.txt");
		if (path !== null) {
			filesystem.writeFile(path, logData.value, false);
		}
	}
}

function p_rint(s) {
	"use strict";
    logData.value += s + "\n";	// optionally write to an in-browser log textarea
    if (hasFs) {
		filesystem.writeFile(logFile, s + "\n", true);
	}
}

function l_og(theStr) {
	"use strict";
	// 2004-09-20 17:36:28.004: theStr

	var d = new Date(),
		year = d.getFullYear().toString(),
		mnth = d.getMonth() + 1,
		month = mnth.toString(),
		date = d.getDate().toString(),
		hours = d.getHours().toString(),
		mins = d.getMinutes().toString(),
		secs = d.getSeconds().toString(),
		ms = d.getMilliseconds().toString();

	if (month.length === 1) {
		month = "0" + month;
	}
	if (date.length === 1) {
		date = "0" + date;
	}
	if (hours.length === 1) {
		hours = "0" + hours;
	}
	if (mins.length === 1) {
		mins = "0" + mins;
	}
	if (secs.length === 1) {
		secs = "0" + secs;
	}
	if (ms.length === 2) {
		ms = "0" + ms;
	} else if (ms.length === 1) {
		ms = "00" + ms;
	}

	p_rint(year + "-" + month + "-" + date + " " + hours + ":" + mins + ":" + secs + "." + ms + ": " + theStr);
}

// The following flags control printing

var eFlag = true;	// show progress and error messages
var sFlag = true;	// show applescripts
var lFlag = true;	// log runCommand() and appleScript() calls


function eprint(theString) {
	"use strict";
	if (eFlag) {
		p_rint(theString);
	}
}
function sprint(theString) {
	"use strict";
	if (sFlag) {
		p_rint(theString);
	}
}
function lprint(theString) {
	"use strict";
	if (lFlag) {
		l_og(theString);
	}
}
