/*
    DTMF Dial
   	Copyright 2004-2016 Harry Whitfield

    This program is free software; you can redistribute it and/or modify it under
    the terms of the GNU General Public License as published by the Free Software
    Foundation; either version 2 of the License, or (at your option) any later
    version.

    This program is distributed in the hope that it will be useful, but WITHOUT ANY
    WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
    PARTICULAR PURPOSE.  See the GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along with
    this program; if not, write to the Free Software Foundation, Inc., 51 Franklin
    St, Fifth Floor, Boston, MA  02110-1301  USA

    DTMF Dial - browser version 1.0
    16 July, 2016
    Copyright 2004-2016 Harry Whitfield
    mailto:g6auc@arrl.net
*/

/*jslint browser, multivar */

/*global newTextArea, eprint */

/*property
    forEach, indexOf, length, split, substring
*/

var countryPref;
var areaPref;
var digitsPref;
var internationalPref;
var nationalPref;
var prefixPref;
var allowPref;
var alfaprocPref;
var numprocPref;

function stripNonDials(theNumber) {
	// remove all "non phone" characters except + ,
	"use strict";
	var valid = "+,0123456789ABCD",
		temp = "";

	theNumber.split("").forEach(function (ele) {
		if (ele === ":") {
			temp += ",";
		} else if (valid.indexOf(ele) >= 0) {
			temp += ele;
		}
	});
	return temp;
}

function stripPlus(theNumber) {
	"use strict";
	// remove all + characters
	var temp = "";

	theNumber.split("").forEach(function (ele) {
		if (ele !== "+") {
			temp += ele;
		}
	});
	return temp;
}

function convert(theNumber) {
	"use strict";
	var countryCode = countryPref,
		areaCode = areaPref,
		maxLocal = digitsPref,
		internationalPrefix = internationalPref,
		nationalPrefix = nationalPref,
		generalPrefix = prefixPref,
		NPP = allowPref,
		it;

	theNumber = stripNonDials(theNumber);
	eprint("NonDials Stripped " + theNumber);
	if (theNumber === "") {
		return "";
	}

	// Supply international prefix if number starts with a +
	if (theNumber[0] === "+") {
		theNumber = internationalPrefix + theNumber.substring(1);
	}
	eprint("+ Prefix Stripped " + theNumber);

	theNumber = stripPlus(theNumber);
	eprint("Extra + Stripped  " + theNumber);

	it = internationalPrefix + countryCode;
	if (it === theNumber.substring(0, it.length)) {
		// if call is for own country then convert to national number
		theNumber = theNumber.substring(it.length);
		eprint("National Number	  " + theNumber);
	} else if (internationalPrefix === theNumber.substring(0, internationalPrefix.length)) {
		// it is an international number
		return generalPrefix + theNumber;
	}

	if (NPP === "1") {
		if (nationalPrefix === theNumber.substring(0, nationalPrefix.length)) {
			theNumber = theNumber.substring(nationalPrefix.length);
			eprint("Nat. Pfx Stripped " + theNumber);
		}
	}

	if (theNumber.length > maxLocal) {
		if (areaCode === theNumber.substring(0, areaCode.length)) {
			// area code not needed for local calls
			theNumber = theNumber.substring(areaCode.length);
			eprint("Local Number	  " + theNumber);
		} else {
			// it is a national number
			return generalPrefix + nationalPrefix + theNumber;
		}
	}

	// it is a local area number
	return generalPrefix + theNumber;
}

function sCC(s, c) {
	"use strict";
	return (s.indexOf(c) >= 0);
}

function map2(c) {
	"use strict";
	if (sCC("abcABC", c)) {
	    return "2";
	}
	if (sCC("defDEF", c)) {
	    return "3";
	}
	if (sCC("ghiGHI", c)) {
	    return "4";
	}
	if (sCC("jklJKL", c)) {
	    return "5";
	}
	if (sCC("mnoMNO", c)) {
	    return "6";
	}
	if (sCC("pqrsPQRS", c)) {
	    return "7";
	}
	if (sCC("tuvTUV", c)) {
	    return "8";
	}
	if (sCC("wxyzWXYZ", c)) {
	    return "9";
	}
	return c;
}

function map(c) {
	"use strict";
	if (alfaprocPref === "0") {
	    return c;
	}
	return map2(c);
}

function mapString(theNumber) {
	"use strict";
	var temp = "";

	theNumber.split("").forEach(function (ele) {
        temp += map2(ele);
    });
	return temp;
}
