/*
    DTMF Dial
   	Copyright 2004-2016 Harry Whitfield

    This program is free software; you can redistribute it and/or modify it under
    the terms of the GNU General Public License as published by the Free Software
    Foundation; either version 2 of the License, or (at your option) any later
    version.

    This program is distributed in the hope that it will be useful, but WITHOUT ANY
    WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
    PARTICULAR PURPOSE.  See the GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along with
    this program; if not, write to the Free Software Foundation, Inc., 51 Franklin
    St, Fifth Floor, Boston, MA  02110-1301  USA

    DTMF Dial - browser version 1.0
    16 July, 2016
    Copyright 2004-2016 Harry Whitfield
    mailto:g6auc@arrl.net
*/

/*jslint browser */

/*global newCheckbox, newImage, newInput, setPreference, getPreferences, cookieAlert,
	moveObj, phoneBookMenu, initSound, initPhoneBook
*/

/*property
    checked, height, left, onchange, onclick, opacity, src, style, top, value,
    width
*/

//////////////////////////////////////// GUI Code ////////////////////////////////////////

var imageBase = "Resources/Images/Panes/";
var prefpanexo = 330;
var prefpaneyo = 170;

var panePref;

var prefPane = newImage(prefpanexo, prefpaneyo, 572, 596, imageBase + "none.png", 1, 1.0);
//var generalPane = newImage(prefpanexo, prefpaneyo, 572, 596, imageBase + "general.png", 1, 0.0);
//var optionsPane = newImage(prefpanexo, prefpaneyo, 572, 474, imageBase + "options.png", 1, 0.0);

/////////////////////////////////////// Text Areas/ //////////////////////////////////////

var countryCode = newInput(prefpanexo + 237, prefpaneyo + 115, 200, 20, "", 2, "opacity:0.0");
var areaCode = newInput(prefpanexo + 237, prefpaneyo + 163, 200, 20, "", 2, "opacity:0.0");
var digitsCode = newInput(prefpanexo + 237, prefpaneyo + 223, 200, 20, "", 2, "opacity:0.0");
var internationalCode = newInput(prefpanexo + 237, prefpaneyo + 283, 200, 20, "", 2, "opacity:0.0");
var nationalCode = newInput(prefpanexo + 237, prefpaneyo + 312, 200, 20, "", 2, "opacity:0.0");
var prefixCode = newInput(prefpanexo + 237, prefpaneyo + 341, 200, 20, "", 2, "opacity:0.0");

var shield = newImage(prefpanexo, 0, 572, prefpaneyo, imageBase + "shield.png", 10, 1.0);

/////////////////////////////////////// Checkboxes ///////////////////////////////////////

var allowCode = newCheckbox(prefpanexo + 235, prefpaneyo + 413, 20, 16, "", 2, "opacity:0.0");

var menuCode = newCheckbox(prefpanexo + 235, prefpaneyo + 114, 20, 16, "", 2, "opacity:0.0");
var alfaprocCode = newCheckbox(prefpanexo + 235, prefpaneyo + 158, 20, 16, "", 2, "opacity:0.0");
var numprocCode = newCheckbox(prefpanexo + 235, prefpaneyo + 201, 20, 16, "", 2, "opacity:0.0");
var longtoneCode = newCheckbox(prefpanexo + 235, prefpaneyo + 248, 20, 16, "", 2, "opacity:0.0");

/////////////////////////////////////// Pane Labels //////////////////////////////////////

var generalLabel = newImage(prefpanexo + 59, prefpaneyo + 54, 49, 55, imageBase + "generalLabel.png", 2, 1.0);
var optionsLabel = newImage(prefpanexo + 112, prefpaneyo + 54, 46, 55, imageBase + "optionsLabel.png", 2, 1.0);
//var windowLabel = newImage(prefpanexo + 455, prefpaneyo + 54, 51, 55, imageBase + "windowLabel.png", 2, 1.0);

/////////////////////////////////////// Other Code ///////////////////////////////////////

function selectPane(pane) {
	"use strict";
	var opacity = 0.0;

	prefPane.style.opacity = opacity;
	prefPane.src = imageBase + pane + ".png";

	countryCode.style.opacity = opacity;
	areaCode.style.opacity = opacity;
	digitsCode.style.opacity = opacity;
	internationalCode.style.opacity = opacity;
	nationalCode.style.opacity = opacity;
	prefixCode.style.opacity = opacity;

	moveObj(countryCode, countryCode.left, 0);
	moveObj(areaCode, areaCode.left, 0);
	moveObj(digitsCode, digitsCode.left, 0);
	moveObj(internationalCode, internationalCode.left, 0);
	moveObj(nationalCode, nationalCode.left, 0);
	moveObj(prefixCode, prefixCode.left, 0);

	allowCode.style.opacity = opacity;
	menuCode.style.opacity = opacity;
	alfaprocCode.style.opacity = opacity;
	numprocCode.style.opacity = opacity;
	longtoneCode.style.opacity = opacity;

	moveObj(allowCode, allowCode.left, 0);
	moveObj(menuCode, menuCode.left, 0);
	moveObj(alfaprocCode, alfaprocCode.left, 0);
	moveObj(numprocCode, numprocCode.left, 0);
	moveObj(longtoneCode, longtoneCode.left, 0);

	switch (pane) {
	case "none":
		prefPane.width = 128;
		prefPane.height = 128;
		break;
	case "general":
		prefPane.width = 572;
		prefPane.height = 596;
		opacity = 1.0;
		prefPane.style.opacity = opacity;
		countryCode.style.opacity = opacity;
		areaCode.style.opacity = opacity;
		digitsCode.style.opacity = opacity;
		internationalCode.style.opacity = opacity;
		nationalCode.style.opacity = opacity;
		prefixCode.style.opacity = opacity;

		moveObj(countryCode, countryCode.left, countryCode.top);
		moveObj(areaCode, areaCode.left, areaCode.top);
		moveObj(digitsCode, digitsCode.left, digitsCode.top);
		moveObj(internationalCode, internationalCode.left, internationalCode.top);
		moveObj(nationalCode, nationalCode.left, nationalCode.top);
		moveObj(prefixCode, prefixCode.left, prefixCode.top);

		allowCode.style.opacity = opacity;
		moveObj(allowCode, allowCode.left, allowCode.top);
		break;
	case "options":
		prefPane.width = 572;
		prefPane.height = 474;
		opacity = 1.0;
		prefPane.style.opacity = opacity;
		menuCode.style.opacity = opacity;
		alfaprocCode.style.opacity = opacity;
		numprocCode.style.opacity = opacity;
		longtoneCode.style.opacity = opacity;

		moveObj(menuCode, menuCode.left, menuCode.top);
		moveObj(alfaprocCode, alfaprocCode.left, alfaprocCode.top);
		moveObj(numprocCode, numprocCode.left, numprocCode.top);
		moveObj(longtoneCode, longtoneCode.left, longtoneCode.top);
		break;
	}
}


///////////////////////////////////// Preference Code ////////////////////////////////////

var countryPref;
var areaPref;
var digitsPref;
var internationalPref;
var nationalPref;
var prefixPref;
var allowPref;
var menuPref;
var alfaprocPref;
var numprocPref;
var longtonePref;

countryCode.onchange = function () {
    "use strict";
	countryPref = countryCode.value;
	setPreference("countryPref", countryPref);
};
areaCode.onchange = function () {
    "use strict";
	areaPref = areaCode.value;
	setPreference("areaPref", areaPref);
};
digitsCode.onchange = function () {
    "use strict";
	digitsPref = digitsCode.value;
	setPreference("digitsPref", digitsPref);
};
internationalCode.onchange = function () {
    "use strict";
	internationalPref = internationalCode.value;
	setPreference("internationalPref", internationalPref);
};
nationalCode.onchange = function () {
    "use strict";
    nationalPref = nationalCode.value;
	setPreference("nationalPref", nationalPref);
};
prefixCode.onchange = function () {
    "use strict";
    prefixPref = prefixCode.value;
	setPreference("prefixPref", prefixPref);
};
allowCode.onchange = function () {
    "use strict";
    allowPref = (allowCode.checked)
    	? "1"
    	: "0";
	setPreference("allowPref", allowPref);
};

menuCode.onchange = function () {
    "use strict";
    menuPref = (menuCode.checked)
    	? "1"
    	: "0";
	phoneBookMenu.style.opacity = menuPref;
	setPreference("menuPref", menuPref);
};
alfaprocCode.onchange = function () {
    "use strict";
    alfaprocPref = (alfaprocCode.checked)
    	? "1"
    	: "0";
	setPreference("alfaprocPref", alfaprocPref);
};
numprocCode.onchange = function () {
    "use strict";
    numprocPref = (numprocCode.checked)
    	? "1"
    	: "0";
	setPreference("numprocPref", numprocPref);
};
longtoneCode.onchange = function () {
    "use strict";
    longtonePref = (longtoneCode.checked)
    	? "1"
    	: "0";
	setPreference("longtonePref", longtonePref);
	initSound();
};

/////////////////////////////////////// Label Code ///////////////////////////////////////

generalLabel.onclick = function () {
    "use strict";
	if (panePref !== 0) {
		selectPane("general");
		panePref = 1;
	}
};

optionsLabel.onclick = function () {
    "use strict";
	if (panePref !== 0) {
		selectPane("options");
		panePref = 2;
	}
};

/*

windowLabel.onclick = function () {
    "use strict";
	if (panePref !== 0) {
		selectPane("window");
		panePref = 6;
	}
};

///////////////////////////////////// initialisation /////////////////////////////////////

selectPane("none");
getPreferences();				// pick up preferences stored as cookies

setSingleMode();				// initial settings
singleCharMode.checked = true;
showKeyLamps.checked = true;
makeSounds.checked = kbSoundPref;
hideDataAreas.checked = true;
*/

selectPane("none");
getPreferences();				// pick up preferences stored as cookies
initSound();
initPhoneBook();
setTimeout(cookieAlert, 2000);	// produce cookie alert if required.
