/*
    DTMF Dial
   	Copyright 2004-2016 Harry Whitfield

    This program is free software; you can redistribute it and/or modify it under
    the terms of the GNU General Public License as published by the Free Software
    Foundation; either version 2 of the License, or (at your option) any later
    version.

    This program is distributed in the hope that it will be useful, but WITHOUT ANY
    WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
    PARTICULAR PURPOSE.  See the GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along with
    this program; if not, write to the Free Software Foundation, Inc., 51 Franklin
    St, Fifth Floor, Boston, MA  02110-1301  USA

    DTMF Dial - browser version 1.0
    16 July, 2016
    Copyright 2004-2016 Harry Whitfield
    mailto:g6auc@arrl.net
*/

/*jslint browser */

/*global Audio */

/*property
    play
*/

var toneURL = [];
var toneBuffer = [];

(function init() {
	"use strict";
	var i = 0;

	while (i < 16) {
		toneURL[i] = "Resources/Sounds_100mS/" + String(i) + ".wav";
		toneBuffer[i] = new Audio(toneURL[i]);
//		document.body.appendChild(toneBuffer[i]);
		i += 1;
	}
}());

function playSound(i) {
    "use strict";
	toneBuffer[i].play();
}

var kURL = "Resources/Sounds_100mS/k.aiff";
var rURL = "Resources/Sounds_100mS/r.aiff";

var kBuffer = new Audio(kURL);
//document.body.appendChild(kBuffer);

var rBuffer = new Audio(rURL);
//document.body.appendChild(rBuffer);

function play(buffer) {
    "use strict";
	buffer.play();
}
