/*
	Web Audio API
	Based on code samples from the page "Getting Started with Web Audio API"
	by Boris Smus at http://www.html5rocks.com/en/tutorials/webaudio/intro/ .
	Code samples licensed under the Apache 2.0 License.
*/

/*jslint browser */

/*global AudioContext, window, alert, XMLHttpRequest, longtonePref */

/*property
    AudioContext, buffer, connect, createBufferSource, decodeAudioData,
    destination, onload, open, response, responseType, send, start,
    webkitAudioContext
*/

var toneBuffer = [];
var toneReady = [];

var kBuffer = null;
var rBuffer = null;
var kReady = false;
var rReady = false;

window.AudioContext = window.AudioContext || window.webkitAudioContext;
var context = new AudioContext();

function onError(e) {
    "use strict";
    alert("sounds:onError: " + e);
}

function loadBuffer(i, url, callback) {
    "use strict";
	var request = new XMLHttpRequest();

	request.open("GET", url, true);
	request.responseType = "arraybuffer";

	request.onload = function () {
    	context.decodeAudioData(request.response, function (buffer) {
			callback(buffer, i);
		}, onError);
	};
	request.send();
}

function initSound() {
	"use strict";
	var kURL = "Resources/Sounds_100mS/k.wav";
	var rURL = "Resources/Sounds_100mS/r.wav";
	var toneURL = [];
	var base;
	var i;

	function callback(buffer, i) {
    	toneBuffer[i] = buffer;
    	toneReady[i] = true;
    	if (i === 16) {
    		kBuffer = buffer;
    		kReady = true;
    	}
    	if (i === 17) {
    		rBuffer = buffer;
    		rReady = true;
    	}
	}

	base = (longtonePref === "0")
		? "Resources/Sounds_100mS/"
		: "Resources/Sounds_300mS/";

	i = 0;
	while (i < 16) {
		toneURL[i] = base + String(i) + ".wav";
		i += 1;
	}
	toneURL[16] = kURL;
	toneURL[17] = rURL;

	i = 0;
	while (i < 18) {
		loadBuffer(i, toneURL[i], callback);
		i += 1;
	}
}

function play(buffer) {
    "use strict";
	var source = context.createBufferSource();

	source.buffer = buffer;
	source.connect(context.destination);
	source.start(0);
}

function playSound(i) {
    "use strict";
	play(toneBuffer[i]);
}
