/*
    Prime Factors - version 1.1.2
    14 March, 2023
    A modified version of Rosetta Code from
	http://www.rosettacode.org/wiki/Prime_decomposition#JavaScript.
	It is made available under the
	Creative Commons Attribution-ShareAlike 4.0 International (CC BY-SA 4.0) License.
	This modified version by Harry Whitfield.
	mailto:g6auc@arrl.net
*/

/*jslint for */

/*property
    floor, forEach, keys, length, push, sort, split, sqrt, substring
*/

/* From http://www.rosettacode.org/wiki/Prime_decomposition#JavaScript

function run_factorize(n) {
    if (n <= 3)
        return [n];

    var ans = [];
    var done = false;
    while (!done) {
        if (n % 2 === 0) {
            ans.push(2);
            n /= 2;
            continue;
        }
        if (n % 3 === 0) {
            ans.push(3);
            n /= 3;
            continue;
        }
        if (n === 1)
            return ans;
        var sr = Math.sqrt(n);
        done = true;
        // try to divide the checked number by all numbers till its square root.
        for (var i = 6; i <= (sr + 6); i += 6) {
            if (n % (i - 1) === 0) { // is n divisible by i-1?
                ans.push((i - 1));
                n /= (i - 1);
                done = false;
                break;
            }
            if (n % (i + 1) === 0) { // is n divisible by i+1?
                ans.push((i + 1));
                n /= (i + 1);
                done = false;
                break;
            }
        }
    }
    ans.push(n);
    return ans;
}
*/

function factorize(n) {	// output in exponential format
	var i;
	var sr;
    var ans = {};
    var done = false;

/*	Examples:
	n = 5120, ans = {"2": 10, "5": 1}
	n = 2880, ans = {"2": 6, "3": 2, "5": 1}
	n = 1920, ans = {"2": 7, "3": 1, "5": 1}
	n = 1080, ans = {"2": 3, "3": 3, "5": 1}
*/

	function record(n) {	// record factor n in ans
		n = String(n);
		if (ans[n] === undefined) {	// factor not previously found
			ans[n] = 1;
		} else {			// factor previously found
			ans[n] += 1;
		}
	}

	if (n <= 3) {
		record(n);
		return ans;
	}

    while (!done) {
        if (n % 2 === 0) {
            record(2);
            n = n / 2;
            continue;
        }
        if (n % 3 === 0) {
            record(3);
            n = n / 3;
            continue;
        }
        if (n === 1) {
            return ans;
        }
        sr = Math.sqrt(n);
        done = true;
        // try to divide the checked number by all numbers till its square root.
        for (i = 6; i <= (sr + 6); i += 6) {
            if (n % (i - 1) === 0) { // is n divisible by i-1?
                record(i - 1);
                n = n / (i - 1);
                done = false;
                break;
            }
            if (n % (i + 1) === 0) { // is n divisible by i+1?
                record(i + 1);
                n = n / (i + 1);
                done = false;
                break;
            }
        }
    }
	record(n);
    return ans;
}

function factors(num, max) {
	var n_factors = [];
  	var i;

  	max = max || 50;

 	for (i = 1; i <= Math.floor(Math.sqrt(num)); i += 1) {
  		if (num % i === 0) {
   			n_factors.push(i);

   			if (num / i !== i) {
    			n_factors.push(num / i);
    		}
    	}
    	if (n_factors.length > max) {
    		return "More than " + max + " factors.";
    	}
  	}
 	n_factors.sort(function (a, b) {
 		return a - b;
 	});  // numeric sort

 	return n_factors;
}

function sup(n) {	// convert integer n to superscript string
	var sS = "⁰¹²³⁴⁵⁶⁷⁸⁹";
	var s = "";

	String(n).split("").forEach(function (c) {
		s += sS[Number(c)];
	});
	return s;
}

function factorsOf(n) {
	var obj = factorize(n);
	var keys = Object.keys(obj);
	var s = String(n) + " = [";

	keys.forEach(function (key) {
		if (obj[key] !== 1) {
			s += key + sup(obj[key]) + ", ";
		} else {
			s += key + ", ";
		}
	});
	s = s.substring(0, s.length - 2) + "]";
	return s;
}

/*
var eprint;

eprint(" ");
eprint(factors(45));  		// 1,3,5,9,15,45
eprint(factors(53));  		// 1,53
eprint(factors(64));  		// 1,2,4,8,16,32,64

eprint(" ");
eprint(factors(5120));		// 1,2,4,5,8,10,16,20,32,40,64,80,128,160,256,320,512,640,1024,1280,2560,5120
eprint(factors(2880));		// 1,2,3,4,5,6,8,9,10,12,15,16,18,20,24,30,32,36,40,45,48,60,64,72,80,90,96,120,144,160,180,192,240,288,320,360,480,576,720,960,1440,2880


eprint(" ");
eprint(factors(1920));		// 1,2,3,4,5,6,8,10,12,15,16,20,24,30,32,40,48,60,64,80,96,120,128,160,192,240,320,384,480,640,960,1920
eprint(factors(1080));		// 1,2,3,4,5,6,8,9,10,12,15,18,20,24,27,30,36,40,45,54,60,72,90,108,120,135,180,216,270,360,540,1080

eprint(" ");
eprint(factorsOf(5120));	// 5120 = [2¹⁰, 5]
eprint(factorsOf(2880));	// 2880 = [2⁶, 3², 5]
eprint(factorsOf(1920));	// 1920 = [2⁷, 3, 5]
eprint(factorsOf(1080));	// 1080 = [2³, 3³, 5]
*/
