/*
	Factors
 	Copyright © 2022-2023 Harry Whitfield

 	This program is free software; you can redistribute it and/or modify it
 	under the terms of the GNU General Public License as published by the
 	Free Software Foundation; either version 2 of the License, or (at your
 	option) any later version.

 	This program is distributed in the hope that it will be useful, but
 	WITHOUT ANY WARRANTY; without even the implied warranty of
 	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 	General Public License for more details.

 	You should have received a copy of the GNU General Public License along
 	with this program; if not, write to the Free Software Foundation, Inc.,
 	51 Franklin St, Fifth Floor, Boston, MA	 02110-1301	 USA

 	Factors - browser version 1.0.2
 	14 March, 2023
 	Copyright © 2022-2023 Harry Whitfield
 	mailto:g6auc@arrl.net
*/

/*jslint browser */

/*global newImage, newInput, addToMenu, newSelector, alert, moveObj, window, scale,
	vtop, left, fScale, writeLogFile, lprint
 */

/*property
    background, backgroundColor, border, clientX, close, hOffset, height,
    innerWidth, maxWidth, onclick, onmousedown, onmouseleave, onmousemove,
    onmouseout, onmouseover, onmouseup, ontouchcancel, ontouchend, ontouchmove,
    ontouchstart, opacity, open, preventDefault, round, size, src, style,
    targetTouches, title, tracking, value, width
*/

//////////////////////////////////////////////////////////////////////////////////////////

var main_window = {width: Math.round(window.innerWidth * scale), height: Math.round(318 * scale)};
var halfWidth = Math.round(main_window.width / 2);
var halfHeight = Math.round(main_window.height / 2);

//////////////////////////////////////////////////////////////////////////////////////////

var base;
var leftTop;
var leftMid;
var leftLow;
var middleTop;
var middleMid;
var middleLow;
var rightTop;
var rightMid;
var rightLow;
var dragbox;
var redButton;
var amberButton;
var greenButton;
var title;
var leftBgOne;
var midBgOne;
var rightBgOne;
var leftBgTwo;
var midBgTwo;
var rightBgTwo;
var leftBgThree;
var midBgThree;
var rightBgThree;
//var leftBgFour;
//var midBgFour;
//var rightBgFour;
var paramOne;
var paramTwo;
var paramThree;
//var paramFour;
var headingOne;
var headingTwo;
var headingThree;
//var headingFour;
var helpButton;
var saveButton;
var font;
var setStyle;
var execButton;
var delta;

(function () {
//  mainWindow.width = Math.round(scale * window.innerWidth);
//  mainWindow.height = Math.round(scale * 318);

// newImage(hOffset, vOffset, width, height, src, zOrder, opacity) {
// newInput(hOffset, vOffset, size, height, value, zOrder, opacity) {
// newTextArea(hOffset, vOffset, cols, rows, value, zOrder, readonly) {
// newCanvas(hOffset, vOffset, width, height, src, zOrder, opacity, hRegP, vRegP)

    base = "Resources/bkgd/";

    delta = 56; // vertical decrement is 56, to reduce from 4 fields to three

    leftTop = newImage(0, 0, 40, 40, base + "bgleftTop.png", 1);
    leftMid = newImage(0, 40, 40, 225 - delta, base + "bgleftMid.png", 1);
    leftLow = newImage(0, 265 - delta, 40, 53, base + "bgleftLow.png", 1);

    middleTop = newImage(40, 0, 200, 40, base + "bgmiddleTop.png", 1);
    middleMid = newImage(40, 40, 200, 225 - delta, base + "bgmiddleMid.png", 1);
    middleLow = newImage(40, 265 - delta, 200, 53, base + "bgmiddleLow.png", 1);

    rightTop = newImage(240, 0, 40, 40, base + "bgrightTop.png", 1);
    rightMid = newImage(240, 40, 40, 225 - delta, base + "bgrightMid.png", 1);
    rightLow = newImage(240, 265 - delta, 40, 53, base + "bgrightLow.png", 1);

    dragbox = newImage(238, 271 - delta, 20, 20, base + "dragbox.png", 2);
    dragbox.tracking = "rectangle";
    dragbox.title = "Drag me to change the widget's width.";

    base = "Resources/buttons/";

    redButton = newImage(28, 21, 21, 14, base + "red.png", 2);
    amberButton = newImage(49, 21, 21, 14, base + "amber.png", 2);
    greenButton = newImage(70, 21, 14, 14, base + "green.png", 2);

//  helpButton = newImage(264, 16, 30, 22, base + "help.png", 2);   // customized
    helpButton = newImage(264, 17, 48, 24, base + "help.png", 2);   // customized

    saveButton = newImage(210, 17, 48, 24, base + "save.png", 2);   // customized

    redButton.title = "Click to close the window.";
    amberButton.title = "Click to clear the data fields.";
    greenButton.title = "Click to toggle the window size.";

    helpButton.title = "Displays information about this program.";
    saveButton.title = "Saves the log file to the downloads folder.";

	execButton = newImage(138, 266 - delta, 64, 24, base + "execute.png", 10);
	execButton.title = "Press to calculate, or press RETURN in any one of the fields.";

    title = newInput(88, 18, 70, 16, "Factors", 2);   // customized
    title.style.backgroundColor = "transparent";
    title.style.border = "none";

    base = "Resources/boxes/";

    leftBgOne = newImage(28, 44, 18, 39, base + "tbleft.png", 2);
    midBgOne = newImage(46, 44, 188, 39, base + "tbmiddle.png", 2);
    rightBgOne = newImage(234, 44, 18, 39, base + "tbright.png", 2);

    leftBgTwo = newImage(28, 100, 18, 39, base + "tbleft.png", 2);
    midBgTwo = newImage(46, 100, 188, 39, base + "tbmiddle.png", 2);
    rightBgTwo = newImage(234, 100, 18, 39, base + "tbright.png", 2);

    leftBgThree = newImage(28, 156, 18, 39, base + "tbleft.png", 2);
    midBgThree = newImage(46, 156, 188, 39, base + "tbmiddle.png", 2);
    rightBgThree = newImage(234, 156, 18, 39, base + "tbright.png", 2);

//    leftBgFour = newImage(28, 212, 18, 39, base + "tbleft.png", 2);
//    midBgFour = newImage(46, 212, 188, 39, base + "tbmiddle.png", 2);
//    rightBgFour = newImage(234, 212, 18, 39, base + "tbright.png", 2);

    paramOne = newInput(37, 53, 200, 20, "", 3);
    paramTwo = newInput(37, 109, 200, 20, "", 3);
    paramThree = newInput(37, 165, 200, 20, "", 3);
//    paramFour = newInput(37, 221, 200, 20, "", 3);

	paramTwo.style.background = "rgba(192 ,192, 192, 1.0)";
	paramThree.style.background = "rgba(192 ,192, 192, 1.0)";

    paramOne.title = "Enter the number to be factorized!";			// customized
    paramTwo.title = "The computed factors.";						// customized
    paramThree.title = "The prime factors in exponential format.";	// customized
//  paramFour.title = "The number in the new base representation.";	// customized

    font = "font-family:Courier;font-weight:normal;font-size:14px";

	setStyle(paramOne, font);
	setStyle(paramTwo, font);
	setStyle(paramThree, font);
//	setStyle(paramFour, font);

    paramOne.style.border = "none";
    paramTwo.style.border = "none";
    paramThree.style.border = "none";
//  paramFour.style.border = "none";

    headingOne = newInput(36, 74, 40, 16, "Number", 2);									// customized
    headingTwo = newInput(36, 130, 40, 16, "Factors", 2);								// customized
    headingThree = newInput(36, 186, 170, 16, "Prime Factors in Exponential Format", 2);// customized
//  headingFour = newInput(36, 242, 120, 16, "Converted Representation", 2);			// customized

    headingOne.style.backgroundColor = "transparent";
    headingTwo.style.backgroundColor = "transparent";
    headingThree.style.backgroundColor = "transparent";
//  headingFour.style.backgroundColor = "transparent";

    headingOne.style.border = "none";
    headingTwo.style.border = "none";
    headingThree.style.border = "none";
//  headingFour.style.border = "none";
}());

//////////////////////////////////////////////////////////////////////////////////////////

var print = function (s) {
    alert(s);
};
var debug = false;
var minWidth = 340;	// customized
var maxWidth = window.innerWidth;	// customized
var curWidth = minWidth;
var dragEnabled = false;

function setUp(width) {
    if (debug) {
        print("setUp():======== start ========:");
        print("width=" + width);
        print("minWidth=" + minWidth);
        print("maxWidth=" + maxWidth);
    }

    if (width < minWidth) {
        width = minWidth;
    }
    if (width > maxWidth) {
        width = maxWidth;
    }

    main_window.width = width;

    middleTop.width = width - 80;
    middleMid.width = width - 80;
    middleLow.width = width - 80;

    rightTop.hOffset = width - 40;
    moveObj(rightTop, width - 40, 0);
    moveObj(rightMid, width - 40, 40);
    moveObj(rightLow, width - 40, 265 - delta);

    midBgOne.width = width - 92;
    midBgTwo.width = width - 92;
    midBgThree.width = width - 92;
//  midBgFour.width = width - 92;

    moveObj(rightBgOne, width - 46, 44);
    moveObj(rightBgTwo, width - 46, 100);
    moveObj(rightBgThree, width - 46, 156);
//  moveObj(rightBgFour, width - 46, 212);

    helpButton.hOffset = width - 75;
    moveObj(helpButton, width - 75, 16);

    saveButton.hOffset = width - 75 - 54;
    moveObj(saveButton, width - 75 - 54, 16);

   	dragbox.hOffset = width - 42;
    moveObj(dragbox, width - 42, 271 - delta);

	execButton.hOffset = width / 2 - 32;
	moveObj(execButton, width / 2 - 32, 266 - delta);

    paramOne.width = Math.round(scale * (width - 80));
    paramTwo.width = paramOne.width;
    paramThree.width = paramOne.width;
//  paramFour.width = paramOne.width;

    paramOne.size = Math.round(scale * (width - 84) / fScale);
    paramTwo.size = paramOne.size;
    paramThree.size = paramOne.size;
//  paramFour.size = paramOne.size;

    paramOne.style.maxWidth = Math.round(scale * (width - 84)) + "px";
    paramTwo.style.maxWidth = paramOne.style.maxWidth;
    paramThree.style.maxWidth = paramOne.style.maxWidth;
//  paramFour.style.maxWidth = paramOne.style.maxWidth;

    if (debug) {
        print("width=" + width);

        print("main_window.width=" + main_window.width);
        print("middleTop.width=" + middleTop.width);
        print("rightTop.hOffset=" + rightTop.hOffset);
        print("paramOne.width=" + paramOne.width);
        print("dragbox.hOffset=" + dragbox.hOffset);

        print("setUp():========  end ========:");
    }

    return width;
}

//////////////////////////////////////////////////////////////////////////////////////////

dragbox.onmousedown = function (evt) {
	evt.preventDefault();
	dragEnabled = true;
};

dragbox.onmouseup = function (evt) {
	evt.preventDefault();
	dragEnabled = false;
};

dragbox.onmouseleave = function (evt) {
	evt.preventDefault();
	dragEnabled = false;
};

dragbox.onmousemove = function (evt) {
//	evt.stopPropagation();
	evt.preventDefault();
    if (dragEnabled) {
        moveObj(dragbox, evt.clientX - 10, 271);
        curWidth = setUp(evt.clientX - 10 + 42);
    }
};

dragbox.ontouchstart = function (evt) {
//	evt.stopPropagation();
    evt.preventDefault();
	dragEnabled = true;
};

dragbox.ontouchend = function (evt) {
//	evt.stopPropagation();
    evt.preventDefault();
	dragEnabled = false;
};

dragbox.ontouchcancel = function (evt) {
//	evt.stopPropagation();
    evt.preventDefault();
	dragEnabled = false;
};

dragbox.ontouchmove = function (evt) {
//	evt.stopPropagation();
	evt.preventDefault();
    if (dragEnabled) {
        moveObj(dragbox, evt.targetTouches[0].clientX - 10, 271);
        curWidth = setUp(evt.targetTouches[0].clientX - 10 + 42);
    }
};

//////////////////////////////////////////////////////////////////////////////////////////

function normalButtons() {
    var base1 = "Resources/buttons/";

    redButton.src = base1 + "red.png";
    amberButton.src = base1 + "amber.png";
    greenButton.src = base1 + "green.png";
}

function activeButtons() {
    var base1 = "Resources/buttons/";

    redButton.src = base1 + "redCross.png";
    amberButton.src = base1 + "amberMinus.png";
    greenButton.src = base1 + "greenPlus.png";
}

redButton.onmouseover = function () {
    activeButtons();
};

redButton.onmouseout = function () {
    normalButtons();
};

amberButton.onmouseover = function () {
    activeButtons();
};

amberButton.onmouseout = function () {
    normalButtons();
};

greenButton.onmouseover = function () {
    activeButtons();
};

greenButton.onmouseout = function () {
    normalButtons();
};

redButton.onclick = function () {
	window.close();
};

redButton.ontouchstart = function (evt) {
	evt.preventDefault();
 	window.close();
};

redButton.ontouchend = function (evt) {
	evt.preventDefault();
	return;
};

function clearData() {
    paramOne.value = "";
    paramTwo.value = "";
    paramThree.value = "";
//  paramFour.value = "";
}

amberButton.onclick = function () {
    clearData();
};

amberButton.ontouchstart = function (evt) {
	evt.preventDefault();
    clearData();
};

amberButton.ontouchend = function (evt) {
	evt.preventDefault();
	return;
};

function toggleWidth() {
    dragEnabled = false;

    if (curWidth === minWidth) {
        curWidth = setUp(maxWidth);
		helpButton.style.opacity = 1.0;
    } else {
        curWidth = setUp(minWidth);
        helpButton.style.opacity = 1.0;
    }
}

greenButton.onclick = function () {
	toggleWidth();
};

greenButton.ontouchstart = function (evt) {
	evt.preventDefault();
	toggleWidth();
};

greenButton.ontouchend = function (evt) {
	evt.preventDefault();
	return;
};

helpButton.onmousedown = function () {
    helpButton.style.opacity = "0.5";
};

helpButton.onmouseup = function () {
    helpButton.style.opacity = "1.0";
    window.open("Help.html");
};

helpButton.ontouchstart = function (evt) {
	evt.preventDefault();
    helpButton.style.opacity = "0.5";
};

helpButton.ontouchend = function (evt) {
	evt.preventDefault();
    helpButton.style.opacity = "1.0";
    window.open("Help.html");
};

saveButton.onmousedown = function () {
    saveButton.style.opacity = "0.5";
};

saveButton.onmouseup = function () {
    saveButton.style.opacity = "1.0";
    writeLogFile();
};

saveButton.ontouchstart = function (evt) {
	evt.preventDefault();
    saveButton.style.opacity = "0.5";
};

saveButton.ontouchend = function (evt) {
	evt.preventDefault();
    saveButton.style.opacity = "1.0";
    writeLogFile();
};

setUp(minWidth);
