/*
	Factors
 	Copyright © 2022-2023 Harry Whitfield

 	This program is free software; you can redistribute it and/or modify it
 	under the terms of the GNU General Public License as published by the
 	Free Software Foundation; either version 2 of the License, or (at your
 	option) any later version.

 	This program is distributed in the hope that it will be useful, but
 	WITHOUT ANY WARRANTY; without even the implied warranty of
 	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 	General Public License for more details.

 	You should have received a copy of the GNU General Public License along
 	with this program; if not, write to the Free Software Foundation, Inc.,
 	51 Franklin St, Fifth Floor, Boston, MA	 02110-1301	 USA

 	Factors - browser version 1.0.2
 	14 March, 2023
 	Copyright © 2022-2023 Harry Whitfield
 	mailto:g6auc@arrl.net
*/

/*jslint browser, devel, this */

/*global paramOne, paramTwo, paramThree, paramFour,
	headingOne, headingTwo, headingThree, headingFour, clearData,
	execButton, eprint, lprint
*/

/*property
    isNaN, keyCode, now, onkeydown, onkeypress, onmousedown, onmouseup, opacity,
    preventDefault, select, stopPropagation, style, toString, value, which
*/

// map custom names onto model names
var numberField = paramOne;
var factorsField = paramTwo;
var expFactorsField = paramThree;
//var calculatedRepr = paramFour;

var numberFieldHeading = headingOne;
var factorsFieldHeading = headingTwo;
var expFactorsFieldHeading = headingThree;
//var calculatedReprHeading = headingFour;

/*
Number.prototype.inRange = function (a, b) {
    return (this >= a) && (this <= b);
}
*/

/////////////////////////////////////////////////////////////////////////////////////////

var factors;
var factorsOf;

/////////////////////////////////////////////////////////////////////////////////////////

function process() {
	var base = parseInt(numberField.value, 10);
	var start;
	var finish;
	var tmp;

   	if (Number.isNaN(base)) {
        expFactorsField.value = "Invalid Number";
        return;
    }
    if ((base < 1) || (base > 9007199254740991)) {
        expFactorsField.value = "Number must > 0 and < 2^53 ≈ 9x10^15";
        return;
    }

	start = Date.now();
	tmp = factors(base).toString();
	finish = Date.now();
	factorsField.value = tmp + "  (" + (finish - start) + "mS)";

	start = Date.now();
	tmp = factorsOf(base);
	finish = Date.now();
	expFactorsField.value = tmp + "  (" + (finish - start) + "mS)";

	eprint("Number: " + base);
	eprint("Factors: " + factorsField.value);
	eprint("Prime Factors: " + expFactorsField.value);
	eprint("---- ----- ----");
}

function test_case() {
	numberField.value = 45;
	factorsField.value = "1,3,5,9,15,45";
	expFactorsField.value = "45 = [3², 5]";
	process();
}

var Return = 13;
var Tab = 9;
var Backspace = 8;

numberField.onkeypress = function (event) {
	var x = event.which || event.keyCode;

	if (x === Return) {
		process();
    } else {
        factorsField.value = "";
        expFactorsField.value = "";
    }
};

factorsField.onkeydown = function (event) {
	var x = event.which || event.keyCode;

 	if (x === Return) {
		process();
	} else if (x === Tab) {
    	event.preventDefault();
		event.stopPropagation();
		expFactorsField.select();
    } else if (x !== Backspace) {
    	event.preventDefault();
		event.stopPropagation();
    }
};

expFactorsField.onkeydown = function (event) {
	var x = event.which || event.keyCode;

 	if (x === Return) {
		process();
	} else if (x === Tab) {
    	event.preventDefault();
		event.stopPropagation();
		numberField.select();
    } else if (x !== Backspace) {
    	event.preventDefault();
		event.stopPropagation();
    }
};

execButton.onmousedown = function () {
	execButton.style.opacity = "0.5";
};
execButton.onmouseup = function () {
	execButton.style.opacity = "1.0";
	process();
};

lprint("Factors web widget started.");
eprint("---- ----- ----");
test_case();
