/*
	Hyperfocal Distance Calculator
 	Copyright © 2019 Harry Whitfield

 	This program is free software; you can redistribute it and/or modify it
 	under the terms of the GNU General Public License as published by the
 	Free Software Foundation; either version 2 of the License, or (at your
 	option) any later version.

 	This program is distributed in the hope that it will be useful, but
 	WITHOUT ANY WARRANTY; without even the implied warranty of
 	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 	General Public License for more details.

 	You should have received a copy of the GNU General Public License along
 	with this program; if not, write to the Free Software Foundation, Inc.,
 	51 Franklin St, Fifth Floor, Boston, MA	 02110-1301	 USA

 	Hyperfocal Distance Calculator - browser version 1.0
 	20 September, 2019
 	Copyright © 2019 Harry Whitfield
 	mailto:g6auc@arrl.net
*/

/*jslint browser, this */

/*global paramOne, paramTwo, paramThree, paramFour,
	headingOne, headingTwo, headingThree, headingFour, clearData
*/

/*property
    inRange, isNaN, keyCode, onkeydown, onkeypress, preventDefault, prototype,
    round, select, stopPropagation, value, which
*/

var gWidgetName;	// global

// map custom names onto model names
var focalLength = paramOne;
var aperture = paramTwo;
var coc = paramThree;
var hyperFocalDist = paramFour;

var focalLengthHeading = headingOne;
var apertureHeading = headingTwo;
var cocHeading = headingThree;
var hyperFocalDistHeading = headingFour;

function hfDistance(f, n, c) {
	// f	focal length in mm
	// n	stop number
	// c	circle of confusion in mm

	return (f * f / (n * c)) + f;
}

Number.prototype.inRange = function (a, b) {
    return (this >= a) && (this <= b);
};

function process() {
    var f = parseFloat(focalLength.value);
    var n = parseFloat(aperture.value);
    var c = parseFloat(coc.value);
    var hfLength;

   	if (Number.isNaN(f)) {
        hyperFocalDist.value = "Invalid Focal Length";
        return;
    }
    if (!f.inRange(1, 5000)) {
        hyperFocalDist.value = "Focal Length Out of Range";
        return;
    }

    if (Number.isNaN(n)) {
        hyperFocalDist.value = "Invalid Aperture";
        return;
    }
    if (!n.inRange(0.5, 512)) {
        hyperFocalDist.value = "Aperture Value Out of Range";
        return;
    }

    if (Number.isNaN(c)) {
        hyperFocalDist.value = "Invalid CoC";
        return;
    }
    if (!c.inRange(0.001, 2.0)) {
        hyperFocalDist.value = "CoC Value Out of Range";
        return;
    }

    hfLength = hfDistance(f, n, c);
    hyperFocalDist.value = Math.round(hfLength);
}

function test_case() {
	focalLength.value = 50;
	aperture.value = 8;
	coc.value = 0.03;
	hyperFocalDist.value = "";
	process();
}

var Return = 13;
var Tab = 9;
var Backspace = 8;

focalLength.onkeypress = function (event) {
	var x = event.which || event.keyCode;

	if (x === Return) {
		process();
    } else {
        hyperFocalDist.value = "";
    }
};

aperture.onkeypress = function (event) {
	var x = event.which || event.keyCode;

	if (x === Return) {
		process();
    } else {
		hyperFocalDist.value = "";
    }
};

coc.onkeypress = function (event) {
	var x = event.which || event.keyCode;

	if (x === Return) {
		process();
    } else {
        hyperFocalDist.value = "";
    }
};

hyperFocalDist.onkeydown = function (event) {
	var x = event.which || event.keyCode;

 	if (x === Return) {
		process();
	} else if (x === Tab) {
    	event.preventDefault();
		event.stopPropagation();
		focalLength.select();
    } else if (x !== Backspace) {
    	event.preventDefault();
		event.stopPropagation();
    }
};

gWidgetName = "HyperFocal Distance Web Widget\n\n";
test_case();
