/*
	IBAN Checker - Checks format and checksum of IBAN numbers
	Copyright © 2009-2015 Harry Whitfield

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License as
	published by the Free Software Foundation; either version 2 of
	the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public
	License along with this program; if not, write to the Free
	Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston,
	MA	02110-1301	USA

	IBAN Checker - browser version 1.0
	11 May, 2015
	Copyright 2009-2015 Harry Whitfield
	mailto:g6auc@arrl.net
*/

/*global newImage, newText, newInput, moveObj, fScale */

/*properties
    close, hOffset, maxWidth, onclick, onmousedown, onmouseout, onmouseover,
    onmouseup, opacity, open, round, size, src, style, title, value, width
*/

/////////////////////////////// Start of the IBAN Checker ////////////////////////////////

//	mainWindow.width  = Math.round(scale * 280);
//	mainWindow.height = Math.round(scale * 318);

// newImage(hOffset, vOffset, width, height, src, zOrder, opacity)
// newText(hOffset, vOffset, width, height, value, zOrder, style)
// newTextArea(hOffset, vOffset, cols, rows, value, zOrder, style)
// newInput(hOffset, vOffset, width, height, value, zOrder, style)
// newCanvas(hOffset, vOffset, width, height, src, zOrder, opacity, hRegP, vRegP)
// newSelector(hOffset, vOffset, width, height, src, zOrder, opacity)

var base = "Resources/images/";

var leftbg 		= newImage(0,   0,  30, 79, base + "leftbg.png",  1, 1.0);
var midbg 		= newImage(30,  0, 260, 79, base + "midbg.png",   1, 1.0);
var rightbg 	= newImage(290, 0,  30, 79, base + "rightbg.png", 1, 1.0);

base = "Resources/buttons/";

var redButton   = newImage(8,  5, 21, 14, base + "red.png",     2);
var amberButton = newImage(29, 5, 21, 14, base + "amber.png",   2);
var greenButton = newImage(50, 5, 14, 14, base + "green.png",   2);
	
redButton.title   = "Click to close the Widget.";
amberButton.title = "Click to clear the data field.";
greenButton.title = "Click to toggle the window size.";
	
var helpButton  = newImage(285, 3, 30,  22, base + "help.png",    2);	// customized
helpButton.title  = "Displays information about this program.";

var style = "background-color:transparent;border:none;text-align:center;font-size:12px;";
var title = newText(105, 3, 80, 18, "IBAN Checker", 2, style);				// customized

base = "Resources/images/";
var cmdHOff = 10;

var comBgLeft   = newImage(cmdHOff,       34,  20, 22, base + "comBgLeft.png", 2);
var comBgMiddle = newImage(cmdHOff +  20, 34, 250, 22, base + "comBgMidd.png", 2);
var comBgRight  = newImage(cmdHOff + 270, 34,  20, 22, base + "comBgRight.png", 2);

var report = newText(70, 58, 160, 16, "", 2, style);
report.value = "";

style = "background-color:transparent;border:none;font-family:'Arial', 'Courier New';font-weight: normal;font-size:14px";

var command = newInput(cmdHOff + 10, 35, 120, 17, "GB13 ABCD 9999 9999 999999", 3, style);
command.title = "Enter an IBAN number, then press the RETURN (or ENTER) key.";

var minWidth = 245;
var maxWidth = 320;
var curWidth = minWidth;

//////////////////////////////////////////////////////////////////////////////////////////

var print = function (s) { alert(s); };
var dragEnabled = false;

function setUp(width) {
	if (width < minWidth) {
		width = minWidth;
	}
	if (width > maxWidth) {
		width = maxWidth;
	}

	midbg.width       = width - 60;
	rightbg.hOffset   = width - 30;
	moveObj(rightbg, width - 30, 0);
	
	comBgMiddle.width  = width - 50;
	comBgRight.hOffset = width - 30;
	moveObj(comBgRight, width - 30, 34);
	
	title.hOffset  = width / 2 - 40;
	moveObj(title,   width / 2 - 40, 3);
	
	report.hOffset = width / 2 - 88;
	moveObj(report,  width / 2 - 88, 58);

	helpButton.hOffset = width - 33;
	moveObj(helpButton, width - 33, 3);

	command.width = width - 40;
	command.size  = Math.round((width - 46) / fScale);
	command.style.maxWidth = String(width - 46) + "px";

	return width;
}

//////////////////////////////////////////////////////////////////////////////////////////

function normalButtons() {
	var base = "Resources/buttons/";
	
	redButton.src   = base + "red.png";
	amberButton.src = base + "amber.png";
	greenButton.src = base + "green.png";
}

function activeButtons() {
	var base = "Resources/buttons/";
	
	redButton.src   = base + "redCross.png";
	amberButton.src = base + "amberMinus.png";
	greenButton.src = base + "greenPlus.png";
}

redButton.onmouseover = function () {
	activeButtons();
};

redButton.onmouseout = function () {
	normalButtons();
};

amberButton.onmouseover = function () {
	activeButtons();
};

amberButton.onmouseout = function () {
	normalButtons();
};

greenButton.onmouseover = function () {
	activeButtons();
};

greenButton.onmouseout = function () {
	normalButtons();
};

redButton.onclick = function () {
	window.close();
};

function clearData() {
	command.value = "";
}

amberButton.onclick = function () {
	clearData();
};

greenButton.onclick = function () {
	dragEnabled = false;
	
	if (curWidth === minWidth) {
		curWidth = setUp(maxWidth);
	} else {
		curWidth = setUp(minWidth);
	}
};

helpButton.onmousedown = function () { this.style.opacity = "0.5"; };
helpButton.onmouseup   = function () { this.style.opacity = "1.0"; window.open("Help.html"); };

setUp(minWidth);
