/*
	IBAN Checker - Checks format and checksum of IBAN numbers
	Copyright © 2009-2015 Harry Whitfield

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License as
	published by the Free Software Foundation; either version 2 of
	the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public
	License along with this program; if not, write to the Free
	Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston,
	MA	02110-1301	USA

	IBAN Checker - browser version 1.0
	11 May, 2015
	Copyright 2009-2015 Harry Whitfield
	mailto:g6auc@arrl.net
*/

/*global ibanData */

/*properties
    indexOf, length, match, name, regexp, substring, toUpperCase
*/

// var ibanData = [..., ["GB", "United Kingdom", 22, /GB\d{2}[A-Z]{4}\d{14}/], ...];

var getData = function (cc) {
	var o = {}, i, item;

	for (i = 0; i < ibanData.length; i += 1) {
		item = ibanData[i];
		if (item[0] === cc) {
			o.name   = item[1];
			o.length = item[2];
			o.regexp = item[3];
			return o;
		}
	}
	o.name = "Not in table";
	o.length = -1;
	o.regexp = null;
	return o;
};

var mod97_10 = function (data) {	// data must be a string of decimal digits
	var grp = 15, i,				// number of digits handled on each cycle (10^15 < 2^50 < 2^53)
		num = data.substring(0, grp);

	num = String(Number(num) % 97);
	for (i = grp; i < data.length; i += grp - 2) {
		num += data.substring(i, i + grp - 2);
		num = String(Number(num) % 97);
	}
	return num;
};

var checkIban = function (iban, generate) {
	var alpha = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ", cc, cd, found, head, kk, tail, s, i, idx, num;

	cc = iban.substring(0, 2);
	cd = getData(cc);

	if (cd.length < 0) {
		return [-100, "Country: " + cd.name];
	}

	if (cd.length !== iban.length) {
		return [-100, "Invalid IBAN length."];
	}

	found = iban.match(cd.regexp);
	if (found === null) {
		return [-100, "Invalid IBAN format."];
	}

	kk = iban.substring(2, 4);
	if ((kk === "01") || (kk === "99") || ((kk === "00") && !generate)) {
		return [-100, "Invalid IBAN check digits."];
	}

	head = iban.substring(0, 4);
	tail = iban.substring(4);
	iban = tail + head;

	iban = iban.toUpperCase();

	s = "";
	for (i = 0; i < iban.length; i += 1) {
		idx = alpha.indexOf(iban[i]);
		if (idx < 0) {
			return [-100, "Invalid character in IBAN."];	// should not occur
		}
		s += String(idx);
	}

	num = mod97_10(s);

	if (num !== "1") {
		return [-num, "Invalid IBAN checksum."];
	}
	return [num, "Country: " + cd.name];
};
