/*
	IBAN Checker - Checks format and checksum of IBAN numbers
	Copyright © 2009-2015 Harry Whitfield

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License as
	published by the Free Software Foundation; either version 2 of
	the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public
	License along with this program; if not, write to the Free
	Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston,
	MA	02110-1301	USA

	IBAN Checker - browser version 1.0
	11 May, 2015
	Copyright 2009-2015 Harry Whitfield
	mailto:g6auc@arrl.net

	The ibanData table (below) is derived from data in the IBAN REGISTRY.
	See below for Legal Notices concerning the IBAN REGISTRY.
*/

/*
Registration Authority for ISO 13616

The Society for Worldwide Interbank Financial Telecommunication SCRL, SWIFT, has
been designated by the ISO Technical Management Board to act as the Registration
Authority for ISO 13616.

IBAN REGISTRY

The registry provides detailed information about all ISO 13616-compliant
national IBAN formats.

Release 57 – April 2015

Legal Notices

Copyright

SWIFT © 2015. All rights reserved.

Disclaimer

SWIFT supplies this publication for information purposes only. The information
in this publication may change from time to time. You must always refer to the
latest available version.

Trademarks and Patents

SWIFT is the trade name of S.W.I.F.T. SCRL. The following are registered
trademarks of SWIFT: the SWIFT logo, SWIFT, SWIFTNet, SWIFTReady, Accord, Sibos,
3SKey, Innotribe, the Standards Forum logo, MyStandards, and SWIFT Institute.
Other product, service, or company names in this publication are trade names,
trademarks, or registered trademarks of their respective owners.
*/

/*properties length, replace */

var ibanData = [["AL", "Albania",						28, /AL\d{10}[A-Za-z0-9]{16}/,				"AL2!n8!n16!c"],
				["AD", "Andorra",						24, /AD\d{10}[A-Za-z0-9]{12}/,				"AD2!n4!n4!n12!c"],
				["AT", "Austria",						20, /AT\d{18}/,								"AT2!n5!n11!n"],
				["AZ", "Republic of Azerbaijan",		28, /AZ\d{2}[A-Z]{4}[A-Za-z0-9]{20}/,		"AZ2!n4!a20!c"],
				["BH", "Bahrain",						22, /BH\d{2}[A-Z]{4}[A-Za-z0-9]{14}/,		"BH2!n4!a14!c"],
				["BE", "Belgium",						16, /BE\d{14}/,								"BE2!n3!n7!n2!n"],
				["BA", "Bosnia and Herzegovina",		20, /BA\d{18}/,								"BA2!n3!n3!n8!n2!n"],
				["BR", "Brazil",						29, /BR\d{25}[A-Z][A-Za-z0-9]/,				"BR2!n8!n5!n10!n1!a1!c"],
				["BG", "Bulgaria",						22, /BG\d{2}[A-Z]{4}\d{6}[A-Za-z0-9]{8}/,	"BG2!n4!a4!n2!n8!c"],
				["CR", "Costa Rica",					21, /CR\d{19}/,								"CR2!n3!n14!n"],
				["HR", "Croatia",						21, /HR\d{19}/,								"HR2!n7!n10!n"],
				["CY", "Cyprus",						28, /CY\d{10}[A-Za-z0-9]{16}/,				"CY2!n3!n5!n16!c"],
				["CZ", "Czech Republic",				24, /CZ\d{22}/,								"CZ2!n4!n6!n10!n"],
				["DK", "Denmark",						18, /DK\d{16}/,								"DK2!n4!n9!n1!n"],
				["FO", "Denmark",						18, /FO\d{16}/,								"FO2!n4!n9!n1!n"],
				["GL", "Denmark",						18, /GL\d{16}/,								"GL2!n4!n9!n1!n"],
				["DO", "Dominican Republic",			28, /DO\d{2}[A-Za-z0-9]{4}\d{20}/,			"DO2!n4!c20!n"],
				["EE", "Estonia",						20, /EE\d{18}/,								"EE2!n2!n2!n11!n1!n"],
				["FI", "Finland",						18, /FI\d{16}/,								"FI2!n6!n7!n1!n"],
				["FR", "France",						27, /FR\d{12}[A-Za-z0-9]{11}\d{2}/,			"FR2!n5!n5!n11!c2!n"],

				["GF", "French Guyana",					27, /GF\d{12}[A-Za-z0-9]{11}\d{2}/,			"GF2!n5!n5!n11!c2!n"],
				["GP", "Guadeloupe",					27, /GP\d{12}[A-Za-z0-9]{11}\d{2}/,			"GP2!n5!n5!n11!c2!n"],
				["MQ", "Martinique",					27, /MQ\d{12}[A-Za-z0-9]{11}\d{2}/,			"MQ2!n5!n5!n11!c2!n"],
				["RE", "Reunion",						27, /RE\d{12}[A-Za-z0-9]{11}\d{2}/,			"RE2!n5!n5!n11!c2!n"],
				["PF", "French Polynesia",				27, /PF\d{12}[A-Za-z0-9]{11}\d{2}/,			"PF2!n5!n5!n11!c2!n"],
				["TF", "French Southern Territories",	27, /TF\d{12}[A-Za-z0-9]{11}\d{2}/,			"TF2!n5!n5!n11!c2!n"],
				["YT", "Mayotte",						27, /YT\d{12}[A-Za-z0-9]{11}\d{2}/,			"YT2!n5!n5!n11!c2!n"],
				["NC", "New Caledonia",					27, /NC\d{12}[A-Za-z0-9]{11}\d{2}/,			"NC2!n5!n5!n11!c2!n"],
				["BL", "Saint Barthelemy",				27, /BL\d{12}[A-Za-z0-9]{11}\d{2}/,			"BL2!n5!n5!n11!c2!n"],
				["MF", "Saint Martin (French part)",	27, /MF\d{12}[A-Za-z0-9]{11}\d{2}/,			"MF2!n5!n5!n11!c2!n"],
				["PM", "Saint Pierre et Miquelon",		27, /PM\d{12}[A-Za-z0-9]{11}\d{2}/,			"PM2!n5!n5!n11!c2!n"],
				["WF", "Wallis and Futuna Islands",		27, /WF\d{12}[A-Za-z0-9]{11}\d{2}/,			"WF2!n5!n5!n11!c2!n"],

				["GE", "Georgia",						22, /GE\d{2}[A-Z]{2}\d{16}/,				"GE2!n2!a16!n"],
				["DE", "Germany",						22, /DE\d{20}/,								"DE2!n8!n10!n"],
				["GI", "Gibraltar",						23, /GI\d{2}[A-Z]{4}[A-Za-z0-9]{15}/,		"GI2!n4!a15!c:"],
				["GR", "Greece",						27, /GR\d{9}[A-Za-z0-9]{16}/,				"GR2!n3!n4!n16!c"],
				["GT", "Guatemala", 					28, /GT\d{2}[A-Za-z0-9]{24}/,				"GT2!n4!c20!c"],
				["HU", "Hungary",						28, /HU\d{26}/,								"HU2!n3!n4!n1!n15!n1!n"],
				["IS", "Iceland",						26, /IS\d{24}/,								"IS2!n4!n2!n6!n10!n"],
				["IE", "Ireland",						22, /IE\d{2}[A-Z]{4}\d{14}/,				"IE2!n4!a6!n8!n"],
				["IL", "Israel",						23, /IL\d{21}/,								"IL2!n3!n3!n13!n"],
				["IT", "Italy",							27, /IT\d{2}[A-Z]\d{10}[A-Za-z0-9]{12}/,	"IT2!n1!a5!n5!n12!c"],
				["KZ", "Kazakhstan",					20, /KZ\d{5}[A-Za-z0-9]{13}/,				"KZ2!n3!n13!c"],
				["KW", "Kuwait",						30, /KW\d{2}[A-Z]{4}[A-Za-z0-9]{22}/,		"KW2!n4!a22!c"],
				["LV", "Latvia",						21, /LV\d{2}[A-Z]{4}[A-Za-z0-9]{13}/,		"LV2!n4!a13!c"],
				["LB", "Lebanon",						28, /LB\d{6}[A-Za-z0-9]{20}/,				"LB2!n4!n20!c"],
				["LI", "Liechtenstein",					21, /LI\d{7}[A-Za-z0-9]{12}/,				"LI2!n5!n12!c"],
				["LT", "Lithuania",						20, /LT\d{18}/,								"LT2!n5!n11!n"],
				["LU", "Luxembourg",					20, /LU\d{5}[A-Za-z0-9]{13}/,				"LU2!n3!n13!c"],
				["MK", "Macedonia",						19, /MK\d{5}[A-Za-z0-9]{10}\d{2}/,			"MK2!n3!n10!c2!n"],
				["MT", "Malta",							31, /MT\d{2}[A-Z]{4}\d{5}[A-Za-z0-9]{18}/, 	"MT2!n4!a5!n18!c"],
				["MR", "Mauritania",					27, /MR\d{25}/,								"MR2!n5!n5!n11!n2!n"],
				["MU", "Mauritius",						30, /MU\d{2}[A-Z]{4}\d{19}[A-Z]{3}/,		"MU2!n4!a2!n2!n12!n3!n3!a"],
				["MD", "Moldova",						24, /MD\d{2}[A-Za-z0-9]{20}/,				"MD2!n20!c"],
				["MC", "Monaco",						27, /MC\d{12}[A-Za-z0-9]{11}\d{2}/,			"MC2!n5!n5!n11!c2!n"],
				["ME", "Montenegro",					22, /ME\d{20}/,								"ME2!n3!n13!n2!n"],
				["NL", "Netherlands",					18, /NL\d{2}[A-Z]{4}\d{10}/,				"NL2!n4!a10!n"],
				["NO", "Norway",						15, /NO\d{13}/,								"NO2!n4!n6!n1!n"],
				["PK", "Pakistan",						24,	/PK\d{2}[A-Z]{4}[A-Za-z0-9]{16}/,		"PK2!n4!a16!c"],
				["PS", "Palestine",						29, /PS\d{2}[A-Z]{4}[A-Za-z0-9]{21}/,		"PS2!n4!a21!c"],
				["PL", "Poland",						28, /PL\d{26}/,								"PL2!n8!n16n"],
				["PT", "Portugal",						25, /PT\d{23}/,								"PT2!n4!n4!n11!n2!n"],
				["RO", "Romania",						24, /RO\d{2}[A-Z]{4}[A-Za-z0-9]{16}/,		"RO2!n4!a16!c"],
				["QA", "Qatar",							29, /QA\d{2}[A-Z]{4}[A-Za-z0-9]{21}/,		"QA2!n4!a21!c"],
				["SM", "San Marino",					27, /SM\d{2}[A-Z]\d{10}[A-Za-z0-9]{12}/,	"SM2!n1!a5!n5!n12!c"],
				["SA", "Saudi Arabia",					24, /SA\d{4}[A-Za-z0-9]{18}/,				"SA2!n2!n18!c"],
				["RS", "Serbia",						22, /RS\d{20}/,								"RS2!n3!n13!n2!n"],
				["SK", "Slovak Republic",				24, /SK\d{22}/,								"SK2!n4!n6!n10!n"],
				["SI", "Slovenia",						19, /SI\d{17}/,								"SI2!n5!n8!n2!n"],
				["ES", "Spain",							24, /ES\d{22}/,								"ES2!n4!n4!n1!n1!n10!n"],
				["SE", "Sweden",						24, /SE\d{22}/,								"SE2!n3!n16!n1!n"],
				["CH", "Switzerland",					21, /CH\d{7}[A-Za-z0-9]{12}/,				"CH2!n5!n12!c"],
				["TN", "Tunisia",						24, /TN\d{22}/,								"TN2!n2!n3!n13!n2!n"],
				["TR", "Turkey",						26, /TR\d{7}[A-Za-z0-9]{17}/,				"TR2!n5!n1!c16!c"],
				["AE", "United Arab Emirates",			23, /AE\d{21}/,								"AE2!n3!n16!n"],
				["GB", "United Kingdom",				22, /GB\d{2}[A-Z]{4}\d{14}/,				"GB2!n4!a6!n8!n"],
				["VG", "Virgin Islands",				24, /VG\d{2}[A-Z]{4}\d{16}/,				"VG2!n4!a16!n"]];

function sToR(sPattern) {
	var res = sPattern
		.replace(/(\d{1,2})\!n/g, "\\d{$1}")
		.replace(/(\d{1,2})\!a/g, "[A-Z]{$1}")
		.replace(/(\d{1,2})\!c/g, "[A-Za-z0-9]{$1}");

	try {
		return new RegExp(res);
	} catch (e) {
		alert("sToR error; " + e);
		return null;
	}
}

(function initIbanData() {
	var i, row, regexp;

	for (i = 0; i < ibanData.length; i += 1) {
		row = ibanData[i];
		regexp =  sToR(row[4]);
		if (regexp !== null) {
			row[3] = regexp;
		}
//		sprint(regexp);
	}
}());
