/*
	IBAN Checker - Checks format and checksum of IBAN numbers
	Copyright © 2009-2015 Harry Whitfield

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License as
	published by the Free Software Foundation; either version 2 of
	the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public
	License along with this program; if not, write to the Free
	Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston,
	MA	02110-1301	USA

	IBAN Checker - browser version 1.0
	11 May, 2015
	Copyright 2009-2015 Harry Whitfield
	mailto:g6auc@arrl.net
*/

/*global command, checkIban, report, mod97_10 */

/*properties
    altKey, color, keyCode, length, onkeypress, replace, style, substring, title,
    value, which
*/

//code to call the checkIban function
function process(altKey) {
	var data = command.value, cc, kk, rs, cs, tooltip;

	data = data.replace(/ /g, "");
	cc = data.substring(0, 2);
	kk = data.substring(2, 4);
	rs = checkIban(data, altKey);
	cs = rs[0];
	tooltip = rs[1];
	command.title = tooltip;

	if (cs === "1") {
		report.style.color = "#000000";
		report.value = "Valid Format and Checksum";
	} else {
		cs = -Number(cs);
		if ((cs < 100) && (kk === "00") && altKey) {
			cs = mod97_10(String(98 - cs));
			if (cs.length === 1) {
				cs = "0" + cs;
			}
			report.style.color = "#0000FF";
			report.value  = "Calculated Check Digits: " + cs;
			tooltip  = "Replacing " + cc + "00 by " + cc + cs;
			tooltip += " will produce a number that passes the checksum test.";
			tooltip += "\nHowever, that does NOT mean that the resulting number is a valid IBAN.";
			command.title = tooltip;
		} else {
			report.style.color = "#FF0000";
			report.value = "Invalid Format or Checksum";
		}
	}
}

command.onkeypress = function (event) {
	var x = event.which || event.keyCode;
	
	if (x === 13) {
		process(event.altKey);
	} else {
		report.value = "";
		command.title = "Enter an IBAN number, then press the return (or enter) key.";
	}
};

process(false);

