/*
	Image Size - Displays the dimensions of an image.
	Copyright © 2011-2019 Harry Whitfield

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the
	Free Software Foundation; either version 2 of the License, or (at your
	option) any later version.

	This program is distributed in the hope that it will be useful, but
	WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the GNU
	General Public License for more details.

	You should have received a copy of the GNU General Public License along
	with this program; if not, write to the Free Software Foundation, Inc.,
	51 Franklin St, Fifth Floor, Boston, MA 02110-1301	USA

	Image Size - browser version 1.2
	22 November, 2019
	Copyright © 2011-2019 Harry Whitfield
	mailto:g6auc@arrl.net
*/

/*jslint browser, devel */

/*property
    bkgdColorPref, clockwisePref, colorPref, forEach, getItem, hAdjustPref,
    keys, legendColorPref, modePref, planimeterPref, rotationPref,
    rulerLengthPref, screenHPref, screenVPref, setItem, textColorPref,
    vAdjustPref
*/

/////////////////////////////////// Storage Preferences //////////////////////////////////

let preferences = {};							// default preferences

preferences.modePref = "100 pixels (10x10)";	// Major Division
preferences.rulerLengthPref = "1500";			// Ruler Length
preferences.clockwisePref = "1";				// Angles Increase Clockwise
preferences.rotationPref = "0";					// Rotation Angle

preferences.screenHPref = "23.486";				// Screen Width
preferences.screenVPref = "13.211";				// Screen Height
preferences.hAdjustPref = "0";					// Horizontal Calibration
preferences.vAdjustPref = "0";					// Vertical Calibration

preferences.colorPref = "#FFFF00";				// Ruler Color
preferences.legendColorPref = "#DDDDDD";		// Legend Bar Color

/*
preferences.buttonColorPref = "#000000";		// Button Color
preferences.textColorPref = "#FFFFFF";			// Rotation Text Color
*/

preferences.planimeterPref = "1";				// planimeter mode = "1"
												// polygon mode = "0"

preferences.textColorPref = "#FFFFFF";			// Planimeter areaText color
preferences.bkgdColorPref = "#000000";			// Planimeter areaText bg color

const widgetName = "ImageSizeNew";	// unique name of web widget

/////////////////////////////////// Storage Access Code //////////////////////////////////

function getPreference(key) {			// getPreference("keyCodesPref");
	let value;

	if (Storage !== undefined) {
		//alert("key: " + key);
		value = localStorage.getItem(widgetName + ":" + key);
		if (value !== null) {
			preferences[key] = value;
		}
	}
	return preferences[key];
}

function setPreference(key, value) {	// setPreference("keyCodesPref", keyCodesPref);
	preferences[key] = value;
	if (Storage !== undefined) {
		localStorage.setItem(widgetName + ":" + key, value);
	}
}

/*
function removePreference(key) {
	if (Storage !== undefined) {
		localStorage.removeItem(widgetName + ":" + key);
	}
}
*/

(function () {							// initial load of stored preferences
	Object.keys(preferences).forEach(function (key) {
		getPreference(key);
	});
}());

export {getPreference, setPreference};