/*
	Interval Calculator - An Interval Calculator
	Copyright © 2006-2015 Harry Whitfield

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the
	Free Software Foundation; either version 2 of the License, or (at your
	option) any later version.

	This program is distributed in the hope that it will be useful, but
	WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
	General Public License for more details.

	You should have received a copy of the GNU General Public License along
	with this program; if not, write to the Free Software Foundation, Inc.,
	51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

	Interval Calculator - browser version 1.0
	2 May, 2015
	Copyright © 2006-2015 Harry Whitfield
	mailto:g6auc@arrl.net
*/

/*global paramOne, paramTwo, paramThree, paramFour, Menu
*/

/*properties
    getTime, join, keyCode, match, onchange, onkeypress, split, toString,
    toUpperCase, value, which
*/

// map custom names onto model names
var currentDate = paramOne;
var inputData   = paramTwo;
var expiryDate  = paramThree;
var message     = paramFour;
/*
var currentDateHeading = headingOne;
var inputDataHeading   = headingTwo;
var expiryDateHeading  = headingThree;
var messageHeading     = headingFour;
*/
var dateFormatMenu = Menu[0];
var dateFormatPref = dateFormatMenu.value;
var mode12 = (dateFormatPref === '12-hour');
var intervalID = null;
var expiryTime = null;

function parseInterval(data) {	// data = '- 2d 4h 30m';
	var days  = 0, hours = 0, mins  = 0,
		pattern = / *(\- *)?(\d{1,5}D *)?(\d{1,2}H *)?(\d{1,2}M)?/,
		item = data.match(pattern),
		sign;
		
	if (item !== null) {
		sign = 1;
		message.value = "";
		if (item[1] !== undefined) { sign = -1; message.value += '- '; }
		if (item[2] !== undefined) { days  = parseInt(item[2], 10); message.value += days  + 'D '; }
		if (item[3] !== undefined) { hours = parseInt(item[3], 10); if (hours < 24) { message.value += hours + 'H '; } else { hours = 0; } }
		if (item[4] !== undefined) { mins  = parseInt(item[4], 10); if (mins  < 60) { message.value += mins  + 'M';  } else { mins  = 0; } }
		message.value += ' accepted.';
	}
	return 1000 * sign * (24 * 3600 * days + 3600 * hours + 60 * mins);
}

function time12HourOf(time) {	// time in format hh:mm:ss
	var ampm = 'am',
		item  = time.split(':'),
		hours = parseInt(item[0], 10);
		
	if (hours > 12) {
		hours -= 12;
		ampm = 'pm';
	} else if (hours === 12) {
		ampm  = 'pm';
	} else if (hours === 0) { hours = 12; }
	
	item[0] = String(hours);
	if (hours < 10) { item[0] = ' ' + item[0]; }
	return item.join(':') + ' ' + ampm;
}

function displayDate(theDate) {
	var theString = theDate.toString(), item;
	if (mode12) {
		item = theString.split(' ');
		item[4] = time12HourOf(item[4]);
		theString = item.join(' ');
	}
	return theString;
}

function updateDate() {	// the timer has fired
	currentDate.value = displayDate(new Date());
}

function calculate() {	// calculate expiry time
	var interval = parseInterval(inputData.value.toUpperCase());
	
	if (interval !== 0) {
		expiryTime = new Date().getTime() + interval;
		expiryDate.value = displayDate(new Date(expiryTime));
	} else { message.value = 'Invalid input data.'; }
}

dateFormatMenu.onchange  = function () {
	dateFormatPref = this.value;
	mode12 = (dateFormatPref === '12-hour');
	updateDate();
	if (expiryTime !== null) {
		expiryDate.value = displayDate(new Date(expiryTime));
	}
};

inputData.onkeypress = function (event) {
	var x = event.which || event.keyCode;
	
	if (x === 13) {
		if (inputData.value !== "") {
			calculate();
		}
	} else {
		expiryDate.value = "";
		expiryTime = null;
		message.value = "";
	}
};

/*
if (intervalID !== null) {
	clearInterval(intervalID);
}
*/

intervalID = setInterval(updateDate, 1000);

updateDate();
