/*
    Lensmaker - computes using the Lensmaker's Equation
    Copyright © 2019 Harry Whitfield

    This program is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by the
    Free Software Foundation; either version 2 of the License, or (at your
    option) any later version.

    This program is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.    See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA

    Lensmaker - browser version 1.0
    6 April, 2019
    Copyright 2019 Harry Whitfield
    mailto:g6auc@arrl.net
*/

/*jslint browser */

/*property
    PI, background, backgroundColor, border, clientX, close, fontFamily,
    fontSize, fontWeight, forEach, hOffset, height, maxWidth, onclick,
    onmousedown, onmousemove, onmouseout, onmouseover, onmouseup, opacity,
    open, round, selectedIndex, setStyle, size, src, style, title, tracking,
    value, width
*/

/*global window, alert, newImage, newInput, newTextArea, newSelector, moveObj,
	scale, fScale
*/

//////////////////////////////////////////////////////////////////////////////////////////

var main_window = {width: Math.round(520 * scale), height: Math.round(318 * scale)};
var halfWidth = Math.round(main_window.width / 2);
var halfHeight = Math.round(main_window.height / 2);

var radToDeg = 180 / Math.PI;
var degToRad = Math.PI / 180;
var rotToPc = 100 / 360;

//////////////////////////////////////////////////////////////////////////////////////////

var base;
var leftTop;
var leftMid;
var leftLow;
var middleTop;
var middleMid;
var middleLow;
var rightTop;
var rightMid;
var rightLow;
var dragbox;
var redButton;
var amberButton;
var greenButton;
var title;
var leftBgOne;
var midBgOne;
var rightBgOne;
var leftBgTwo;
var midBgTwo;
var rightBgTwo;
var leftBgThree;
var midBgThree;
var rightBgThree;
var leftBgFour;
var midBgFour;
var rightBgFour;
var leftBgFive;
var midBgFive;
var rightBgFive;
var paramOne;
var paramTwo;
var paramThree;
var paramFour;
var paramFive;
var headingOne;
var headingTwo;
var headingThree;
var headingFour;
var headingFive;
var helpButton;
var style;

(function () {
    "use strict";
//  mainWindow.width = Math.round(scale * 280);
//  mainWindow.height = Math.round(scale * 318);

// newImage(hOffset, vOffset, width, height, src, zOrder, opacity) {
// newInput(hOffset, vOffset, size, height, value, zOrder, opacity) {
// newTextArea(hOffset, vOffset, cols, rows, value, zOrder, style) {
// newCanvas(hOffset, vOffset, width, height, src, zOrder, opacity, hRegP, vRegP)

    base = "Resources/bkgd/";

    leftTop = newImage(0, 0, 40, 40, base + "bgleftTop.png", 1);
    leftMid = newImage(0, 40, 40, 281, base + "bgleftMid.png", 1);
    leftLow = newImage(0, 321, 40, 53, base + "bgleftLow.png", 1);

    middleTop = newImage(40, 0, 200, 40, base + "bgmiddleTop.png", 1);
    middleMid = newImage(40, 40, 200, 281, base + "bgmiddleMid.png", 1);
    middleLow = newImage(40, 321, 200, 53, base + "bgmiddleLow.png", 1);

    rightTop = newImage(240, 0, 40, 40, base + "bgrightTop.png", 1);
    rightMid = newImage(240, 40, 40, 281, base + "bgrightMid.png", 1);
    rightLow = newImage(240, 321, 40, 53, base + "bgrightLow.png", 1);

    dragbox = newImage(238, 327, 20, 20, base + "dragbox.png", 2);
    dragbox.tracking = "rectangle";
    dragbox.title = "Click to enable - move over me to change the widget's width - click again to disable.";

    base = "Resources/buttons/";

    redButton = newImage(28, 21, 21, 14, base + "red.png", 2);
    amberButton = newImage(49, 21, 21, 14, base + "amber.png", 2);
    greenButton = newImage(70, 21, 14, 14, base + "green.png", 2);

    helpButton = newImage(450, 16, 30, 22, base + "help.png", 2);       // customized

    redButton.title = "Click to close the Widget.";
    amberButton.title = "Click to clear the data fields.";
    greenButton.title = "Click to toggle the window size.";

    helpButton.title = "Displays information about this program.";

    title = newInput(88, 18, 95, 16, "Lensmaker Equation", 2);                          // customized
    title.style.backgroundColor = "transparent";
    title.style.border = "none";

    base = "Resources/boxes/";

    leftBgOne = newImage(28, 44, 18, 39, base + "tbleft.png", 2);
    midBgOne = newImage(46, 44, 188, 39, base + "tbmiddle.png", 2);
    rightBgOne = newImage(234, 44, 18, 39, base + "tbright.png", 2);

    leftBgTwo = newImage(28, 100, 18, 39, base + "tbleft.png", 2);
    midBgTwo = newImage(46, 100, 188, 39, base + "tbmiddle.png", 2);
    rightBgTwo = newImage(234, 100, 18, 39, base + "tbright.png", 2);

    leftBgThree = newImage(28, 156, 18, 39, base + "tbleft.png", 2);
    midBgThree = newImage(46, 156, 188, 39, base + "tbmiddle.png", 2);
    rightBgThree = newImage(234, 156, 18, 39, base + "tbright.png", 2);

    leftBgFour = newImage(28, 212, 18, 39, base + "tbleft.png", 2);
    midBgFour = newImage(46, 212, 188, 39, base + "tbmiddle.png", 2);
    rightBgFour = newImage(234, 212, 18, 39, base + "tbright.png", 2);

    leftBgFive = newImage(28, 268, 18, 39, base + "tbleft.png", 2);
    midBgFive = newImage(46, 268, 188, 39, base + "tbmiddle.png", 2);
    rightBgFive = newImage(234, 268, 18, 39, base + "tbright.png", 2);

    paramOne = newInput(37, 53, 200, 20, "", 3);
    paramTwo = newInput(37, 109, 200, 20, "", 3);
    paramThree = newInput(37, 165, 200, 20, "", 3);
    paramFour = newInput(37, 221, 200, 20, "", 3);
    paramFive = newInput(39, 277, 200, 20, "", 3);

    paramFive.style.background = "rgba(192 ,192, 192, 1.0)";

    paramOne.title = "Enter Refractive Index [0.95,5].";					// customized
    paramTwo.title = "Radius One in meters [-20,-0.001] or [0.001,20].";	// customized
    paramThree.title = "Radius Two in meters [-20,-0.001] or [0.001,20].";	// customized
    paramFour.title = "Thickness in meters [0.0001,0.5].";  				// customized
    paramFive.title = "Output Power (diopters).";							// customized

    style = "font-family:Courier;font-weight:normal;font-size:14px";

    paramOne.style.setStyle(style);
    paramTwo.style.setStyle(style);
    paramThree.style.setStyle(style);
    paramFour.style.setStyle(style);
    paramFive.style.setStyle(style);

    paramOne.style.border = "none";
    paramTwo.style.border = "none";
    paramThree.style.border = "none";
    paramFour.style.border = "none";
    paramFive.style.border = "none";

    paramOne.style.background = "rgba(204, 255, 204, 1.0)";
    paramTwo.style.background = "rgba(204, 255, 204, 1.0)";
    paramThree.style.background = "rgba(204, 255, 204, 1.0)";
    paramFour.style.background = "rgba(204, 255, 204, 1.0)";
    paramFive.style.background = "rgba(192 ,192, 192, 1.0)";

    headingOne = newInput(36, 74, 80, 16, "Refractive Index", 2);   		// customized
    headingTwo = newInput(36, 130, 55, 16, "Radius One", 2);    			// customized
    headingThree = newInput(36, 186, 55, 16, "Radius Two", 2);    			// customized
    headingFour = newInput(36, 242, 55, 16, "Thickness", 2);				// customized
    headingFive = newInput(36, 298, 115, 16, "Output Power (diopters)", 2);	// customized

    headingOne.style.backgroundColor = "transparent";
    headingTwo.style.backgroundColor = "transparent";
    headingThree.style.backgroundColor = "transparent";
    headingFour.style.backgroundColor = "transparent";
    headingFive.style.backgroundColor = "transparent";

    headingOne.style.border = "none";
    headingTwo.style.border = "none";
    headingThree.style.border = "none";
    headingFour.style.border = "none";
    headingFive.style.border = "none";
}());

var minWidth = 280;                                                             // customized
var maxWidth = 510;                                                             // customized
var curWidth = minWidth;

//////////////////////////////////////////////////////////////////////////////////////////

var print = function (s) {
    "use strict";
    alert(s);
};
var debug = false;
var dragEnabled = false;

function setUp(width) {
    "use strict";
    if (debug) {
        print("setUp():======== start ========:");
        print("width=" + width);
        print("minWidth=" + minWidth);
        print("maxWidth=" + maxWidth);
    }

    if (width < minWidth) {
        width = minWidth;
    }
    if (width > maxWidth) {
        width = maxWidth;
    }

    main_window.width = width;

    middleTop.width = width - 80;
    middleMid.width = width - 80;
    middleLow.width = width - 80;

    rightTop.hOffset = width - 40;
    moveObj(rightTop, width - 40, 0);
    moveObj(rightMid, width - 40, 40);
    moveObj(rightLow, width - 40, 321);

    midBgOne.width = width - 92;
    midBgTwo.width = width - 92;
    midBgThree.width = width - 92;
    midBgFour.width = width - 92;
    midBgFive.width = width - 92;

    moveObj(rightBgOne, width - 46, 44);
    moveObj(rightBgTwo, width - 46, 100);
    moveObj(rightBgThree, width - 46, 156);
    moveObj(rightBgFour, width - 46, 212);
    moveObj(rightBgFive, width - 46, 268);

    dragbox.hOffset = width - 42;
    moveObj(dragbox, width - 42, 327);

    helpButton.hOffset = width - 55;
   	moveObj(helpButton, width - 55, 16);

    paramOne.width = Math.round(scale * (width - 80));
    paramTwo.width = paramOne.width;
    paramThree.width = paramOne.width;
    paramFour.width = paramOne.width;
    paramFive.width = paramOne.width;

    paramOne.size = Math.round(scale * (width - 84) / fScale);
    paramTwo.size = paramOne.size;
    paramThree.size = paramOne.size;
    paramFour.size = paramOne.size;
    paramFive.size = paramOne.size;

    paramOne.style.maxWidth = Math.round(scale * (width - 84)) + "px";
    paramTwo.style.maxWidth = paramOne.style.maxWidth;
    paramThree.style.maxWidth = paramOne.style.maxWidth;
    paramFour.style.maxWidth = paramOne.style.maxWidth;
    paramFive.style.maxWidth = paramOne.style.maxWidth;

    if (debug) {
        print("width=" + width);

//      print('main_window.width=' + main_window.width);
        print("middleTop.width=" + middleTop.width);
        print("rightTop.hOffset=" + rightTop.hOffset);
        print("paramOne.width=" + paramOne.width);
        print("dragbox.hOffset=" + dragbox.hOffset);

        print("setUp():========  end ========:");
    }

    return width;
}

//////////////////////////////////////////////////////////////////////////////////////////

dragbox.onclick = function () {
    "use strict";
    dragEnabled = !dragEnabled;
};

dragbox.onmousemove = function (event) {
    "use strict";
    if (dragEnabled) {
        moveObj(dragbox, event.clientX - 10, 271);
        curWidth = setUp(event.clientX - 10 + 42);
    }
};

function normalButtons() {
    "use strict";
    var base1 = "Resources/buttons/";

    redButton.src = base1 + "red.png";
    amberButton.src = base1 + "amber.png";
    greenButton.src = base1 + "green.png";
}

function activeButtons() {
    "use strict";
    var base1 = "Resources/buttons/";

    redButton.src = base1 + "redCross.png";
    amberButton.src = base1 + "amberMinus.png";
    greenButton.src = base1 + "greenPlus.png";
}

redButton.onmouseover = function () {
    "use strict";
    activeButtons();
};

redButton.onmouseout = function () {
    "use strict";
    normalButtons();
};

amberButton.onmouseover = function () {
    "use strict";
    activeButtons();
};

amberButton.onmouseout = function () {
    "use strict";
    normalButtons();
};

greenButton.onmouseover = function () {
    "use strict";
    activeButtons();
};

greenButton.onmouseout = function () {
    "use strict";
    normalButtons();
};

redButton.onclick = function () {
    "use strict";
    window.close();
};

function clearData() {
    "use strict";
    paramOne.value = "";
    paramTwo.value = "";
    paramThree.value = "";
    paramFour.value = "";
    paramFive.value = "";
}

amberButton.onclick = function () {
    "use strict";
    clearData();
};

greenButton.onclick = function () {
    "use strict";
    dragEnabled = false;

    if (curWidth === minWidth) {
        curWidth = setUp(maxWidth);
    } else {
        curWidth = setUp(minWidth);
    }
};

helpButton.onmousedown = function () {
    "use strict";
    helpButton.style.opacity = "0.5";
};
helpButton.onmouseup = function () {
    "use strict";
    helpButton.style.opacity = "1.0";
    window.open("Help.html");
};

setUp(minWidth);
