/*
	Lunar Date - A Gregorian to Lunar date converter.
	Copyright © 2004-2015 Harry Whitfield

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the
	Free Software Foundation; either version 2 of the License, or (at your
	option) any later version.

	This program is distributed in the hope that it will be useful, but
	WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
	General Public License for more details.

	You should have received a copy of the GNU General Public License along
	with this program; if not, write to the Free Software Foundation, Inc.,
	51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
	
	Lunar Date - version 1.9.1
	31 March, 2008 - updated 30 April, 2015
	Copyright © 2004-2015 Harry Whitfield
	mailto:g6auc@arrl.net
*/

/*global jdClockBase, mSecsPerDay, getJulianDay */

/*properties
    document, floor, getTime, getUTCDate, getUTCFullYear, getUTCHours,
    getUTCMinutes, getUTCMonth, getUTCSeconds, length, open, round, sqrt, write
*/

function dateOf(jd) {
	return new Date((jd - jdClockBase) * mSecsPerDay);
}

function moonIndex(jd) {
	// D = 5.597661 + 29.5305888610*N + (102.026E-12)*N*N
	// where D is the number of days (and fractions) since 2000-01-01 00:00:00 (JD2451544.5), and N is an integer.
	var D = jd - 2451544.5,
		a = 102.026E-12,
		b = 29.5305888610,
		c = 5.597661 - D;
		
	return Math.floor((-b + Math.sqrt(b * b - 4 * a * c)) / (2 * a));
}

function jd(N) {
	var a = 102.026E-12,
		b = 29.5305888610,
		c = 5.597661 + 2451544.5;
	
	return c + b * N + a * N * N;
}

function makeISODateTime(theDate) {
	var year  = theDate.getUTCFullYear(),
		month = theDate.getUTCMonth(), // 0..11
		date  = theDate.getUTCDate(),
		hours = theDate.getUTCHours(),
		mins  = theDate.getUTCMinutes(),
		secs  = theDate.getUTCSeconds(),

		sYear  = String(year),
		sMonth = String(month + 1), // "1".."12"
		sDate  = String(date),
	
		sHours = String(hours),
		sMins  = String(mins),
		sSecs  = String(secs);

	while (sYear.length < 4) { sYear  = "0" + sYear;  }
	if (sMonth.length  === 1) { sMonth = "0" + sMonth; }
	if (sDate.length   === 1) { sDate  = "0" + sDate;  }
	
	if (sHours.length  === 1) { sHours = "0" + sHours; }
	if (sMins.length   === 1) { sMins  = "0" + sMins;  }
	if (sSecs.length   === 1) { sSecs  = "0" + sSecs;  }

	return sYear + sMonth + sDate + 'T' + sHours + sMins + sSecs + 'Z';
}

function calEvent(isoDate, summary) {
	var s = '';
	
	s += 'BEGIN:VEVENT\r\n';
	s += 'DTSTART:' + isoDate + '\r\n';
	s += 'DTEND:'   + isoDate + '\r\n';
	s += 'SUMMARY:' + summary + '\r\n';
	s += 'END:VEVENT\r\n';
	return s;
}

function writeFile(data) {
	var	calWindow = window.open("", "calWindow", "width=600, height=650"),
		s = "<pre>" + data + "</pre>";
		
    calWindow.document.write(s);
}

function makeCalFile(julianDay) {
	var year  = dateOf(julianDay).getUTCFullYear(),
		Dec31 = getJulianDay("CE", year - 1, 12, 31, 12, 0, 0),	// at noon
//		Jan1  = getJulianDay("CE",     year,  1,  1,  0, 0, 0),	// at midnight

		s = 'BEGIN:VCALENDAR\r\n',

		N = moonIndex(Dec31),
		theOldDate = dateOf(jd(N)),
		theOldYear = theOldDate.getUTCFullYear(),
		oldDateTime =  makeISODateTime(theOldDate),
	
		i,
		theNewDate,
		theNewYear,
		newDateTime,
		
		theMidDate,
		theMidYear,
		theMidDateTime;

	if (theOldYear === year) { s += calEvent(oldDateTime, 'New Moon'); }
	
	for (i = 1; i < 14; i += 1) {
		theNewDate  = dateOf(jd(N + i));
		theNewYear  = theNewDate.getUTCFullYear();
		newDateTime = makeISODateTime(theNewDate);
		
		theMidDate  = new Date(Math.round(0.5 * (theOldDate.getTime() + theNewDate.getTime())));
		theMidYear = theMidDate.getUTCFullYear();
		theMidDateTime = makeISODateTime(theMidDate);
		
		if (theMidYear === year) { s += calEvent(theMidDateTime, 'Full Moon'); }
				
		if (theNewYear === year) { s += calEvent(newDateTime, 'New Moon'); }
		
		theOldDate = theNewDate;
	}
	s += 'END:VCALENDAR\r\n';
	
//	filesystem.writeFile(preferences.iCalFolderPref.value + '/LunarDates' + year + '.ics', s);
	
	writeFile(s);
}
