/*
	Lunar Date - A Gregorian to Lunar date converter.
	Copyright © 2004-2015 Harry Whitfield

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the
	Free Software Foundation; either version 2 of the License, or (at your
	option) any later version.

	This program is distributed in the hope that it will be useful, but
	WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
	General Public License for more details.

	You should have received a copy of the GNU General Public License along
	with this program; if not, write to the Free Software Foundation, Inc.,
	51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

	Lunar Date - browser version 1.0
	30 April, 2015
	Copyright © 2004-2015 Harry Whitfield
	mailto:g6auc@arrl.net
*/

/*global paramOne, paramTwo, paramThree, paramFour,
	headingOne, headingTwo, headingThree, headingFour, clearData, Menu,
	setUp, maxWidth,
	
	CalDate, makeCalFile, today, convertDate, theMonths, lunarMonths,
	getJulianDay, newMoon, monthLen, hijriDay, weekDay
*/

/*properties
    day, floor, keyCode, length, month, onchange, onkeypress, round, split,
    toFixed, toString, value, which, year
*/

// map custom names onto model names
var gregorian = paramOne;
var lunar     = paramTwo;
var weekday   = paramThree;
var julian    = paramFour;
/*
var gregorianHeading = headingOne;
var lunarHeading = headingTwo;
var weekdayHeading = headingThree;
var julianHeading = headingFour;
*/
var dateFormatMenu    = Menu[0];
var sightingDelayMenu = Menu[1];

var gregyDate = new CalDate(1,  1, 2000, "AD");
var lunarDate = new CalDate(24, 9, 1420, "AH");

var julianDay = 0;

var dateFormat = dateFormatMenu[0];
var sightingDelay = sightingDelayMenu[2];
var dateSep    = "/";

function pad(x, n) {
	x = x.toString();
	while (x.length < n) { x = "0" + x; }
	return x;
}

function parseDate(s, era) {
	var item = s.split(dateSep, 3);
	
	switch (dateFormat) {
	case "dd/mm/yyyy":
		return new CalDate(parseInt(item[0], 10), parseInt(item[1], 10),  parseInt(item[2], 10),  era);
	case "mm/dd/yyyy":
		return new CalDate(parseInt(item[1], 10), parseInt(item[0], 10),  parseInt(item[2], 10),  era);
	case "yyyy-mm-dd":
		return new CalDate(parseInt(item[2], 10), parseInt(item[1], 10),  parseInt(item[0], 10),  era);
	}
}

function getMoonArea(age) {	// age in days
	var moonArea = [0.0,  1.4,  5.8, 12.7, 21.6, 32.0, 43.1, 54.3,	// 20090524 - 20090531
				         64.9, 74.6, 83.1, 89.9, 95.1, 98.5, 99.9,	// 20090601 - 20090607
			 	         99.5, 97.3, 93.3, 87.9, 81.1, 73.1, 64.1,	// 20090608 - 20090614
			 	         54.4, 44.3, 34.1, 24.2, 15.2,  7.8,  2.6,	// 20090615 - 20090621
			 	          0.2,  0.7,  4.3, 10.6],					// 20090622 - 20090625
		day = Math.floor(age),
		rem = age - day,
	
		delta0 = moonArea[day + 1] - moonArea[day],
		delta1 = moonArea[day + 2] - moonArea[day + 1],
		delta2 = delta1 - delta0;
		
	return (moonArea[day] + rem * delta0 + 0.5 * rem * (rem - 1) * delta2).toFixed(1);
}

function displayData(gregyDate, lunarDate) {
	var age, len, agePercent;
	
	switch (dateFormat) {
	case "dd/mm/yyyy":
		gregorian.value = pad(gregyDate.day, 2) + '/' + pad(gregyDate.month, 2) + '/' + pad(gregyDate.year, 4) + " CE    (" + theMonths[gregyDate.month - 1]   + ")";
   		lunar.value     = pad(lunarDate.day, 2) + '/' + pad(lunarDate.month, 2) + '/' + pad(lunarDate.year, 4) + " AH    (" + lunarMonths[lunarDate.month - 1] + ")";
   		break;
		
	case "mm/dd/yyyy":
		gregorian.value = pad(gregyDate.month, 2) + '/' + pad(gregyDate.day, 2) + '/' + pad(gregyDate.year, 4) + " CE    (" + theMonths[gregyDate.month - 1]   + ")";
   		lunar.value     = pad(lunarDate.month, 2) + '/' + pad(lunarDate.day, 2) + '/' + pad(lunarDate.year, 4) + " AH    (" + lunarMonths[lunarDate.month - 1] + ")";
   		break;
		
	case "yyyy-mm-dd":
		gregorian.value = pad(gregyDate.year, 4) + '-' + pad(gregyDate.month, 2) + '-' + pad(gregyDate.day, 2) + " CE    (" + theMonths[gregyDate.month - 1]   + ")";
   		lunar.value     = pad(lunarDate.year, 4) + '-' + pad(lunarDate.month, 2) + '-' + pad(lunarDate.day, 2) + " AH    (" + lunarMonths[lunarDate.month - 1] + ")";
   		break;
	}
   	julianDay = getJulianDay("CE", gregyDate.year, gregyDate.month, gregyDate.day, 12, 0, 0);
   	age =  newMoon(julianDay);
   	len = monthLen(julianDay);
   	agePercent = 100 * age / len;
   	julian.value    = julianDay + '          ' + age.toFixed(2) + ' ' +  Math.round(agePercent) + '% ' + getMoonArea(age) + '%';
	weekday.value   = weekDay(julianDay) + '        (' + hijriDay(julianDay) + ')';
}

function setToday(altKey) {
	var gregyDate, lunarDate;
	
	if (altKey) {
		if (julian.value !== "") { makeCalFile(julianDay); } else { alert("Please enter a date, then try again!"); }
	} else {
		gregyDate  = today();
		lunarDate  = convertDate(gregyDate);
		if (lunarDate.year !== 0) { displayData(gregyDate, lunarDate); }
	}
}

function updatePrefs() {
	dateFormat = dateFormatMenu.value;
	dateSep    = "/";
	if (dateFormat === "yyyy-mm-dd") { dateSep = "-"; }
	sightingDelay = Number(sightingDelayMenu.value) / 24;
	setUp(maxWidth);
	setToday(false);
}

dateFormatMenu.onchange  = function () {
	updatePrefs();
};

sightingDelayMenu.onchange  = function () {
	updatePrefs();
};

gregorian.onkeypress = function (event) {
	var x = event.which || event.keyCode;
	
	if (x === 13) {
		gregyDate = parseDate(gregorian.value, 'CE');				
		lunarDate = convertDate(gregyDate);
		if (lunarDate.year !== 0) {
			displayData(gregyDate, lunarDate);
		} else {
			lunar.value = "Invalid Date";
			julian.value = "";
			weekday.value = "";
		}
	} else {
		lunar.value = "";
		weekday.value = "";
		julian.value = "";
	}
};

lunar.onkeypress = function (event) {
	var x = event.which || event.keyCode;
	
	if (x === 13) {
		lunarDate = parseDate(lunar.value, 'AH');
		gregyDate = convertDate(lunarDate);
		if (gregyDate.year !== 0) {
			displayData(gregyDate, lunarDate);
		} else {
			gregorian.value = "Invalid Date";
			julian.value = "";
			weekday.value = "";
		}
	} else {
		gregorian.value = "";
		weekday.value = "";
		julian.value = "";
	}
};

updatePrefs();
setToday(false);
