/*
	Style.setSytle(styleString)
	
	Copyright © 2007,2014 Harry Whitfield
	
	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License as
	published by the Free Software Foundation; either version 2 of
	the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public
	License along with this program; if not, write to the Free
	Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston,
	MA  02110-1301  USA
	
	Style.setSytle(styleString) - version 1.2
	5 October, 2014
	Copyright © 2007,2014 Harry Whitfield
	mailto:g6auc@arrl.net
*/

/*properties
    KonBackgroundFill, KonShadow, KonShadowColor, KonShadowOffset,
    KonTextTruncation, background, backgroundAttachment, backgroundColor,
    backgroundImage, backgroundPosition, backgroundRepeat, color, fontFamily,
    fontSize, fontStretch, fontStyle, fontWeight, indexOf, length, opacity,
    prototype, replace, setStyle, split, textAlign, textDecoration
*/

///////////////////////////////// Start of the setStyle function /////////////////////////////////
Object.prototype.setStyle = function (styleString) {
    var item, key, value, items = styleString.split(';'), last = items[items.length - 1], i;
    
	function trim(s) {
		return s.replace(/^\s+|\s+$/g, "");
	}

    if ((last === "") || (last.indexOf(":") === -1)) { items.length -= 1; } 	// remove empty entry
    	
    for (i = 0; i < items.length; i += 1) {
        item  = items[i].split(":");
        key   = trim(item[0]);
        value = trim(item[1]);
        
		switch (key) {
		case "background":				
			this.background			  = value; 
			break;
		case "background-attachment":	
			this.backgroundAttachment = value; 
			break;
		case "background-color":		
			this.backgroundColor	  = value; 
			break;
		case "background-image":		
			this.backgroundImage	  = value; 
			break;
		case "background-position":		
			this.backgroundPosition	  = value; 
			break;
		case "background-repeat":		
			this.backgroundRepeat	  = value; 
			break;
		case "color":					
			this.color				  = value; 
			break;
		case "font-family":				
			this.fontFamily			  = value; 
			break;
		case "font-size":				
			this.fontSize			  = value; 
			break;
		case "font-style":				
			this.fontStyle			  = value; 
			break;
		case "font-stretch":			
			this.fontStretch		  = value; 
			break;
		case "font-weight":				
			this.fontWeight			  = value; 
			break;
		case "opacity":					
			this.opacity			  = value; 
			break;
		case "text-align":				
			this.textAlign			  = value; 
			break;
		case "text-decoration":			
			this.textDecoration		  = value; 
			break;
		case "-kon-background-fill":	
			this.KonBackgroundFill	  = value; 
			break;
		case "-kon-shadow":				
			this.KonShadow			  = value; 
			break;
		case "-kon-shadow-color":		
			this.KonShadowColor		  = value; 
			break;
		case "-kon-shadow-offset":		
			this.KonShadowOffset	  = value; 
			break;
		case "-kon-text-truncation":	
			this.KonTextTruncation	  = value; 
			break;
		default:						
			break;
        }
    }
};
///////////////////////////////// End  of  the setStyle function /////////////////////////////////
