/*
	Morse Key - browser version 1.2
	29 April, 2019
	Copyright 2012-2019 Harry Whitfield
	mailto:g6auc@arrl.net
*/

/*jslint browser, devel */

/*global confirm, newImage, newCanvas, newCanvasImage, newTextArea, newSelector, addToMenu,
	morse, drawImage, newFileSelector, FileReader, window, dotBuffer, dashBuffer,
	dotReady, dashReady, document, File, FileReader, FileList, Blob, alert,
	getPreference, setPreference
*/

/*property
    Blob, File, FileList, FileReader, addEventListener, dataTransfer,
    dropEffect, files, fromCharCode, indexOf, init, keyCode, match, name,
    onchange, onclick, onkeydown, onkeypress, onload, onmousedown, onmouseup,
    opacity, open, preventDefault, readAsText, result, selectedIndex, shiftKey,
    size, stop, stopPropagation, style, title, type, update, value, which
*/

// window 313 x 300

// newImage(hOffset, vOffset, width, height, src, zOrder, opacity)
// newCanvas(hOffset, vOffset, width, height, src, zOrder, opacity, hRegP, vRegP)
// newCanvasImage(canvas);
// newTextArea(hOffset, vOffset, cols, rows, value, zOrder, style)
// newSelector(hOffset, vOffset, width, height, src, zOrder, opacity)
// newFileSelector(hOffset, vOffset, width, height, value, zOrder, style)

var meter = newImage(0, 0, 233, 238, "Resources/Images/image2.png", 1, 1.0);
var pointer = newCanvas(136 - 90, 195 - 90, 180, 180, "Resources/Images/pointer.png", 2, 1.0, 90, 90);
meter.title = "Shift-click to send the test message.\nUse the esc key in the display text area to stop a transmission.";
pointer.title = meter.title;
var pointerImage = newCanvasImage(pointer);
//var dragBar = newImage(100, 237, 73, 8, "Resources/Images/dragBar.png", 1, 1.0);

var style = "font-family:'Lucida Grande','Lucida Sans Unicode';font-weight:normal;font-size:14px;color:black;border:none";
var input = newTextArea(10, 260, 25, 5, "", 3, style);
input.title = "The display text area.";

var files = newFileSelector(10, 239, 100, 20, "", 3);
files.title = "Choose a text file to be used as the test message, or drag a text file onto the display text area (below).";

var helpButton = newImage(200, 46, 30, 22, "Resources/Images/help.png", 2);	// customized
helpButton.title = "Displays information about this program.";
helpButton.onmousedown = function () {
    "use strict";
    helpButton.style.opacity = "0.5";
};
helpButton.onmouseup = function () {
    "use strict";
    helpButton.style.opacity = "1.0";
    window.open("Help.html");
};

var speedPref;
morse.update(Number(speedPref));

//////////////////////////////////// Menus Customized ////////////////////////////////////

var MenuArray = [
	["5", "7", "10", "12", "15", "18", "20"]
];

var MenuTitleArray = [
	"Select the transmission speed (in w.p.m)."
];

var Menu = [];

Menu[0] = newSelector(180, 10, 110, 20, "", 2);

addToMenu(Menu[0], MenuArray[0]);
Menu[0].selectedIndex = MenuArray.indexOf(speedPref);
Menu[0].title = MenuTitleArray[0];
Menu[0].value = speedPref;

//////////////////////////////////////////////////////////////////////////////////////////

var gFile = null;
var fMode = false;
var firstTime = true;

function write(s) {
    "use strict";
    input.value = s;
}

function append(s) {
    "use strict";
	if (fMode) {
	    input.value += s;
	}
}

function readText(file, callback) {
    "use strict";
	var reader = new FileReader();

	reader.onload = function () {
		callback(reader.result);
	};
	reader.readAsText(file);
}

function doIt() {
    "use strict";
	var data = "<Now is the time for all good men to come to the aid of the party.>";
//	var data = "<CQ CQ CQ DE G6AUC G6AUC K >";
//	var data = "<paris paris paris paris paris paris >";

	function callback(text) {
		morse(text, 2);	// delay starting for two seconds
	}

	if (firstTime) {
		if (dotReady && dashReady) {
			morse.init(dotBuffer, dashBuffer);
			firstTime = false;
		} else {
			write("Please wait for the sound files to load.");
			return;
		}
	}

	if (gFile !== null) {
		write("");
		fMode = true;
		readText(gFile, callback);
		return;
	}

	write("");
	fMode = true;
	morse(data, 2);	// delay starting for two seconds
}

Menu[0].onchange = function () {
    "use strict";
	var speedx = Menu[0].value;

	morse.update(Number(speedx));
	setPreference("speedPref", speedx);
};

meter.onclick = function (event) {
    "use strict";
	if (event.shiftKey) {
	    doIt();
	}
};

pointer.onclick = function (event) {
    "use strict";
	if (event.shiftKey) {
	    doIt();
	}
};

input.onkeypress = function (event) {
    "use strict";
	var x = event.which || event.keyCode;

	if (firstTime) {
		if (dotReady && dashReady) {
			morse.init(dotBuffer, dashBuffer);
			firstTime = false;
		} else {
			write("Please wait for the sound files to load.");
			return;
		}
	}

	fMode = false;
	if (x === 13) {
		morse(" ");
	} else if ((x !== 8) && (x !== 27)) {
		morse(String.fromCharCode(x));
	}
};

input.onkeydown = function (event) {
    "use strict";
	var x = event.which || event.keyCode;

	if (firstTime) {
		if (dotReady && dashReady) {
			morse.init(dotBuffer, dashBuffer);
			firstTime = false;
		} else {
			write("Please wait for the sound files to load.");
			return;
		}
	}

	fMode = false;
	if (x === 8) {
		morse("^");
	} else if (x === 27) {
		morse.stop();
	}
};

function check(file) {
    "use strict";
	if (!file.type.match(/^text\/\S*/)) {
		write("File \"" + file.name + "\" is not a text file.");
		return null;
	}

	if (file.size > 1024) {
		write("File \"" + file.name + "\" is too long (" + file.size + " bytes).");
		return null;
	}

	write("Using file \"" + file.name + "\" (" + file.size + " bytes).");
	return file;
}

files.onchange = function () {
    "use strict";
	var file = files.files[0];

	gFile = check(file);
};

(function (textArea) {
    "use strict";
    function handleDrop(evt) {
        var file;

        evt.stopPropagation();
        evt.preventDefault();

        file = evt.dataTransfer.files[0];
        gFile = check(file);
    }

    function handleDragOver(evt) {
        evt.stopPropagation();
        evt.preventDefault();
        evt.dataTransfer.dropEffect = "copy";
    }

    if (File && FileReader && FileList && Blob) {
        textArea.addEventListener("dragover", handleDragOver, false);
        textArea.addEventListener("drop", handleDrop, false);
    } else {
        alert("File APIs are missing.");
    }

}(input));

window.onload = function () {	// wait for image to load
    "use strict";
	drawImage(pointer, pointerImage, 0, 0, -33);	// -33 <= ang <= 33
	if (!(window.File && window.FileReader && window.FileList && window.Blob)) {
        write("The file API isn't supported on this browser.");
    }
};
