/*
	Web Audio API
	Based on code samples from the page "Getting Started with Web Audio API"
	by Boris Smus at http://www.html5rocks.com/en/tutorials/webaudio/intro/ .
	Code samples licensed under the Apache 2.0 License.
*/

/*jslint browser */

/*global AudioContext, window, alert, XMLHttpRequest */

/*properties
    AudioContext, buffer, connect, createBufferSource, decodeAudioData,
    destination, onload, open, response, responseType, send, start,
    webkitAudioContext
*/

var dotURL = "Resources/Sounds/dot120.mp3";
var dashURL = "Resources/Sounds/dash240.mp3";
var dotBuffer = null;
var dashBuffer = null;
var dotReady = false;
var dashReady = false;

window.AudioContext = window.AudioContext || window.webkitAudioContext;
var context = new AudioContext();

function onError(e) {
    "use strict";
    alert(e);
}

function loadBuffer(url, callback) {
    "use strict";
	var request = new XMLHttpRequest();

	request.open("GET", url, true);
	request.responseType = "arraybuffer";

	request.onload = function () {
    	context.decodeAudioData(request.response, function (buffer) {
			callback(buffer);
		}, onError);
	};
	request.send();
}

loadBuffer(dotURL, function (buffer) {
    "use strict";
    dotBuffer = buffer;
    dotReady = true;
});
loadBuffer(dashURL, function (buffer) {
    "use strict";
    dashBuffer = buffer;
    dashReady = true;
});

function playSound(buffer) {
    "use strict";
	var source = context.createBufferSource();

	source.buffer = buffer;
	source.connect(context.destination);
	source.start(0);
}
