#include <iostream.h>
#include <fstream.h>
#include <iomanip.h>
#include <math.h>
#include <errno.h>
#include <stdio.h>
#include <stdlib.h>

int count;

// See Numerical Recipes in C by Press, Flannery,Teukolsky and Vetterling,
// CUP, 1988. ISBN 0-521-35465-X, 174-176.

float erfc(float x)
{
    // returns the complementary error function erfc(x) with fractional error
    // everywhere less than 1.2 x 10^(-7)

    float t, z, ans;

    z = fabs(x);
    t = 1.0 / (1.0 + 0.5*z);
    ans = t*exp(-z*z -1.26551223 + t*(1.00002368 + t*(0.37409196 + t*(0.09678418 +
          t*(-0.18628806 + t*(0.27886807 + t*(-1.13520398 + t*(1.48851587 +
          t*(-0.82215223 + t*0.17087277)))))))));
          return x >= 0.0 ? ans : 2.0 - ans;
}

float erf(float x)      // The error function erf(x)
{
    return 1 - erfc(x);
}

float F(float x)        // The (Cumulative) Normal Distribution Function
{
    const float m = 1.0 / sqrt(2.0);

    return 0.5 + 0.5*erf(m*x);
}

float invF(float x)     // The Inverse Normal Distribution Function
{
    const float epsilon = 0.000001;
    const float xmax    = 0.9999999;

    float xtry, y, ymin, ymax;

    float z = 1.0;

    errno = 0;
    if ( (x < 0.0) || (x > 1.0) )   // Test for domain error
    {
        errno = EDOM;
        return 0.0;
    }

    if (x < 0.5) { x = 1 - x; z = -1.0; }

    y = 0.67;           // initial guess
    ymin = 0.0;         // lower bound
    ymax = 4.864687;    // upper bound ( = infinity )

    if (x >= xmax) return z * ymax;

    for (;;)            // find solution by binary search
    {
        xtry = F(y);
        if (fabs(xtry - x) < epsilon) return z * y;
        if (xtry > x) ymax = y; else ymin = y;
        y = 0.5 * (ymax + ymin);    // next guess
        count++;
    }
}

float invF1(float x)    // The Inverse Normal Distribution Function
{
    // Code by p.l.goldsmith (1960) and h.whitfield (1960, 2000).
    // Original invErf table from unknown source (possibly p.l.goldsmith).
    // This table re-computed to 8 decimal places by h.whitfield (2000).

    const float invErf[130] =
    {
        0.00000016, 0.02506870, 0.05015338, 0.07526970, 0.10043361,
        0.12566143, 0.15096943, 0.17637423, 0.20189337, 0.22754487,
        0.25334710, 0.27931899, 0.30548096, 0.33185342, 0.35845885,
        0.38532043, 0.41246325, 0.43991303, 0.46769893, 0.49585032,
        0.52440041, 0.55338448, 0.58284175, 0.61281288, 0.64334518,
        0.67448944, 0.70630240, 0.73884690, 0.77219296, 0.80642158,
        0.84162116, 0.87789607, 0.91536546, 0.95416498, 0.99445766,
        1.03643358, 1.08031964, 1.12639153, 1.17498708, 1.20035887,
        1.22652793, 1.25356543, 1.28155136, 1.31057906, 1.34075522,
        1.37220407, 1.40507197, 1.43953216, 1.47579169, 1.51410222,
        1.55477285, 1.59819293, 1.64485288, 1.66456282, 1.68494070,
        1.70604253, 1.72793472, 1.75068665, 1.77438283, 1.79911721,
        1.82500744, 1.85218012, 1.88079476, 1.91103554, 1.94313240,
        1.97736740, 2.01409101, 2.05375051, 2.09692645, 2.14441085,
        2.15707159, 2.17008901, 2.18348622, 2.19728732, 2.21151686,
        2.22621393, 2.24140334, 2.25712919, 2.27343464, 2.29036784,
        2.30798197, 2.32635117, 2.34552908, 2.36561918, 2.38670874,
        2.40891099, 2.43237734, 2.45725918, 2.48376560, 2.51214409,
        2.54269934, 2.57582998, 2.61205721, 2.65206909, 2.69684124,
        2.70647383, 2.71637893, 2.72655559, 2.73702049, 2.74777365,
        2.75887895, 2.77031994, 2.78216076, 2.79437017, 2.80702734,
        2.82016444, 2.83378148, 2.84795904, 2.86274433, 2.87816954,
        2.89429903, 2.91122866, 2.92905426, 2.94784021, 2.96774578,
        2.98886728, 3.01146150, 3.03565598, 3.06183434, 3.09025288,
        3.12142372, 3.15592289, 3.19464684, 3.23887444, 3.29052711,
        3.35274100, 3.43159604, 3.54002190, 3.71898270, 4.86468700
    };

    const float epsilon = 0.000001;
    const float xmax    = 0.9999999;
    const float ytop    = 4.864687; // upper bound ( = infinity )

    float xtry, y, ymin, ymax;
    float a;
    int i;
    float z = 1.0;

    errno = 0;
    if ( (x < 0.0) || (x > 1.0) )   // Test for domain error
    {
        errno = EDOM;
        return 0.0;
    }

    if (x < 0.5)    { x = 1.0 - x; z = -1.0; }

    if (x < 0.88)        { a = 100*x -     50;  }   // use relevant section
    else if (x < 0.95)   { a = 200*x -    138;  }   // of the table
    else if (x < 0.984)  { a = 500*x -    423;  }
    else if (x < 0.9965) { a = 2000*x -  1899;  }
    else if (x < 0.9999) { a = 10000*x - 9871;  }
    else if (x < xmax)   { a = 128.5;           }
    else return z*ytop;

    i = a;
    a = a - i;
    ymin = invErf[i]; ymax = invErf[i+1];
    y = (1 - a)*ymin + a*ymax;                      // linear interpolation

    ymin = ymin - 0.00001;
    ymax = ymax + 0.00001;

    //cout << "ymin= " << ymin << "  ";
    //cout << "ymax= " << ymax << "  ";
    //cout << "y=    " << y    << endl;

    for (;;)                                        // find solution by binary search
    {
        count++;
        xtry = F(y);
        if (fabs(xtry - x) < epsilon) return z * y;
        if (xtry > x) ymax = y; else ymin = y;
        y = 0.5 * (ymax + ymin);    // next guess

        //cout << "xtry= " << xtry << "  ";
        //cout << "ymin= " << ymin << "  ";
        //cout << "ymax= " << ymax << "  ";
        //cout << "y=    " << y    << endl;

        if (count > 19)
        {
            cout << "count= " << count << endl;
            return 0.0;
        }
    }
}

int main()
{
    float x;
    float result;

    for (;;)
    {
        cout << "Enter x: ";
        cin >> x;

        count = 0;

        result = invF1(x);
        if ( (result == 0.0) && (errno != 0) )
        {
            perror("Invalid argument for invF()");
        }
        else
        {
            cout << "invF1(x) = " << result << endl;
            cout << "iterations= " << count << endl;
        }
    }
    return 0;
}
