/*
	Ohm's Law - An Ohm's Law Calculator
	Copyright © 2004-2015 Harry Whitfield

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the
	Free Software Foundation; either version 2 of the License, or (at your
	option) any later version.

	This program is distributed in the hope that it will be useful, but
	WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
	General Public License for more details.

	You should have received a copy of the GNU General Public License along
	with this program; if not, write to the Free Software Foundation, Inc.,
	51 Franklin St, Fifth Floor, Boston, MA	 02110-1301	 USA
	
	Ohm's Law - browser version 1.0
	25 April, 2015
	Copyright © 2004-2015 Harry Whitfield
	mailto:g6auc@arrl.net
*/

/*global paramOne, paramTwo, paramThree, paramFour,
	headingOne, headingTwo, headingThree, headingFour, clearData, Menu
*/

/*properties
    background, keyCode, onchange, onkeypress, selectedIndex, sqrt, style,
    toFixed, value, which
*/

// map custom names onto model names
var voltage	   = paramOne;
var current	   = paramTwo;
var resistance = paramThree;
var power	   = paramFour;

var voltageHeading	  = headingOne;
var currentHeading	  = headingTwo;
var resistanceHeading = headingThree;
var powerDropHeading  = headingFour;

var outputModeMenu = Menu[0];

var mode	 = 3;	// Circuit Length
/*
var modeText = ['Voltage and Current','Voltage and Resistance','Voltage and Power',
				'Current and Resistance','Current and Power','Resistance and Power'];
*/
var modeValue = [3, 5, 9, 6, 10, 12];

function process() {
	var V, C, R, P;
	
	switch (mode) { // P=8, R=4, C=2, V=1
	case 3:
		V = parseFloat(voltage.value);
		C = parseFloat(current.value);
		resistance.value = (V / C).toFixed(4);
		power.value		 = (V * C).toFixed(4);
		break;
	
	case 5:
		V = parseFloat(voltage.value);
		R = parseFloat(resistance.value);
		current.value = (V / R).toFixed(4);
		power.value	  = (V * V / R).toFixed(4);
		break;
				
	case 6:
		C = parseFloat(current.value);
		R = parseFloat(resistance.value);
		voltage.value = (R * C).toFixed(4);
		power.value	  = (C * C * R).toFixed(4);
		break;

	case 9:
		V = parseFloat(voltage.value);
		P = parseFloat(power.value);
		current.value	 = (P / V).toFixed(4);
		resistance.value = (V * V / P).toFixed(4);
		break;

	case 10:
		C = parseFloat(current.value);
		P = parseFloat(power.value);
		voltage.value	 = (P / C).toFixed(4);
		resistance.value = (P / (C * C)).toFixed(4);
		break;

	case 12:
		R = parseFloat(resistance.value);
		P = parseFloat(power.value);
		voltage.value = Math.sqrt(P * R).toFixed(4);
		current.value = Math.sqrt(P / R).toFixed(4);
		break;

	default:
		break;
	}
}

outputModeMenu.onchange	 = function () {
	mode = modeValue[this.selectedIndex];

	voltage.style.background	= "rgba(255, 255, 255, 1.0)";
	current.style.background	= "rgba(255, 255, 255, 1.0)";
	resistance.style.background = "rgba(255, 255, 255, 1.0)";
	power.style.background		= "rgba(255, 255, 255, 1.0)";

	switch (mode) { // 3,5,9,6,10,12
	case 3:
		resistance.style.background = "rgba(192, 192, 192, 1.0)";
		power.style.background		= "rgba(192, 192, 192, 1.0)";
		break;
	case 5:
		current.style.background = "rgba(192, 192, 192, 1.0)";
		power.style.background	 = "rgba(192, 192, 192, 1.0)";
		break;
	case 9:
		current.style.background	= "rgba(192, 192, 192, 1.0)";
		resistance.style.background = "rgba(192, 192, 192, 1.0)";
		break;
	case 6:
		voltage.style.background = "rgba(192, 192, 192, 1.0)";
		power.style.background	 = "rgba(192, 192, 192, 1.0)";
		break;
	case 10:
		voltage.style.background	= "rgba(192, 192, 192, 1.0)";
		resistance.style.background = "rgba(192, 192, 192, 1.0)";
		break;
	case 12:
		voltage.style.background	= "rgba(192, 192, 192, 1.0)";
		current.style.background	= "rgba(192, 192, 192, 1.0)";
		break;
	}
};

voltage.onkeypress = function (event) {
	var x = event.which || event.keyCode;
	
	if (x === 13) { process(); }
};

current.onkeypress = function (event) {
	var x = event.which || event.keyCode;
	
	if (x === 13) { process(); }
};

resistance.onkeypress = function (event) {
	var x = event.which || event.keyCode;
	
	if (x === 13) { process(); }
};

power.onkeypress = function (event) {
	var x = event.which || event.keyCode;
	
	if (x === 13) { process(); }
};

outputModeMenu.onchange();
