/*
	PIN DeCoder - Encrypts and decrypts four-digit PIN numbers
	Copyright 2004-2016 Harry Whitfield

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the
	Free Software Foundation; either version 2 of the License, or (at your
	option) any later version.

	This program is distributed in the hope that it will be useful, but
	WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the GNU
	General Public License for more details.

	You should have received a copy of the GNU General Public License along
	with this program; if not, write to the Free Software Foundation, Inc.,
	51 Franklin St, Fifth Floor, Boston, MA	02110-1301	USA

	PIN DeCoder - version 1.4 - webwidget version
	30 November, 2016
	Copyright 2004-2016 Harry Whitfield
	mailto:g6auc@arrl.nets
*/

/*jslint browser, for, multivar */

/*global newImage, newInput, window */

/*property
    close, keyCode, length, onclick, onkeypress, onmouseout, onmouseover,
    opacity, src, style, title, toString, toUpperCase, value, which
*/

var background = newImage(0, 0, 160, 160, "Resources/bg.png", 1, 1.0);

var redButton = newImage(32, 13, 14, 14, "Resources/buttons/red.png", 2, 0.0);
redButton.title = "Close the Widget.";

var style = "font-family:'Lucida Grande',Helvetica;font-size:12px;color:black;background-color:#C0C080;border:none;text-align:center;opacity:0.0";

var master = newInput(66, 29, 30, 20, "", 2, style);
master.title = "Enter master PIN in this box.";

var pin = newInput(66, 74, 30, 20, "", 2, style);
pin.title = "Enter a PIN in this box, then press RETURN.";

var report = newInput(66, 116, 30, 20, "", 2, style);
report.title = "The (de)coded pin appears in this box.";

var helpButton = newImage(130, 9, 30, 22, "Resources/buttons/help.png", 2);
helpButton.title = "Displays information about this program.";
helpButton.onmousedown = function () {
    "use strict";
    this.style.opacity = "0.5";
};
helpButton.onmouseup = function () {
    "use strict";
    this.style.opacity = "1.0";
    window.open("Resources/Help.html", "", "width=800,height=1300");
};

var timeoutID = null;

// The following flag controls printing in the debug console window
var hex = function (a, n) {	// return n least significant hex digits of a with leading zeros
		"use strict";
		var x, r = "", i;

		for (i = 0; i < n; i += 1) {
			x = a % 16;
			a = (a - x) / 16;
			r = x.toString(16).toUpperCase() + r;
		}
		return r;
	},

	code = function (keyData, pinData) {
		"use strict";
		var a = Number("0x" + keyData),
			b = Number("0x" + pinData),
			c;

		if (isNaN(a) || isNaN(b)) {
			return "ERROR";
		}
		c = (a ^ b);
		return hex(c, 4);
	};

function show() {
	"use strict";
	redButton.style.opacity = 1.0;
	master.style.opacity = 1.0;
	pin.style.opacity = 1.0;
	report.style.opacity = 1.0;
}

function hide() {
	"use strict";
	redButton.style.opacity = 0.1;
	master.style.opacity = 0.1;
	pin.style.opacity = 0.1;
	report.style.opacity = 0.1;

	master.value = "";
	pin.value = "";
	report.value = "";
}

function clear() {
	"use strict";
	if (timeoutID) {
		clearTimeout(timeoutID);
		timeoutID = null;
	}
}

function onkeypress(event) {
	"use strict";
	var x = event.which || event.keyCode;

	if ((x === 13) && (pin.value.length === 4) && (master.value.length === 4)) {
	    report.value = code(master.value, pin.value);
	} else {
	    report.value = "";
	}
}

redButton.onclick = function () {
    "use strict";
    window.close();
};

redButton.onmouseover = function () {
    "use strict";
    var base1 = "Resources/buttons/";

    redButton.src = base1 + "redCross.png";
    redButton.style.opacity = 1.0;
};

redButton.onmouseout = function () {
    "use strict";
    var base1 = "Resources/buttons/";

    redButton.src = base1 + "red.png";
};

master.onkeypress = function (event) {
    "use strict";
	onkeypress(event);
};

pin.onkeypress = function (event) {
    "use strict";
	onkeypress(event);
};

master.onmouseover = clear;

pin.onmouseover = clear;

report.onmouseover = clear;

background.onmouseover = function () {
	"use strict";
	clear();
	show();
};

background.onmouseout = function () {
	"use strict";
	clear();
	timeoutID = setTimeout(hide, 5000);
};
