/*
    Cookies
    Copyright © 2016,2019 Harry Whitfield

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License as
    published by the Free Software Foundation; either version 2 of
    the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public
    License along with this program; if not, write to the Free
    Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston,
    MA  02110-1301  USA

    Cookies - browser version 1.6 for ProtractorWeb
    11 February, 2019
    Copyright © 2016,2019 Harry Whitfield
    mailto:g6auc@arrl.net
*/

/*jslint browser, devel */

/*property
    cookie, cookieEnabled, getTime, indexOf, length, replace, setTime, split,
    substring, toUTCString
*/

///////////////////////////////////////// cookies ////////////////////////////////////////

var permitCookies = false;
var gWidgetName = "";

function setCookie(name, value, days, prefix) {
	var date;
	var expires = "";
	var path = "";
	var cookie;

	if (navigator.cookieEnabled && permitCookies) {
		if (days) {
			date = new Date();
			date.setTime(date.getTime() + 86400000 * days);
			expires = "; expires=" + date.toUTCString();
			if (prefix) {
				path = "; path=" + prefix;
			}
		}
		cookie = name + "=" + encodeURIComponent(value) + expires + path;
		document.cookie = cookie;
	}
}

function getCookie(name) {
	var lookFor = name + "=";
	var cookies = document.cookie.split(";");
	var i;
	var cookie;

	i = 0;
	while (i < cookies.length) {
		cookie = cookies[i].replace(/^\s+|\s+$/g, "");
		if (cookie.indexOf(lookFor) === 0) {
			return decodeURIComponent(cookie.substring(lookFor.length));
		}
		i += 1;
	}
	return "";
}

function deleteCookie(name) {
	setCookie(name, encodeURIComponent(name), -1);
}

function cookiesPermitted() {
    if (navigator.cookieEnabled && !permitCookies) {
        permitCookies = confirm(
        	gWidgetName +
            "This site can use cookies (small text files stored on your phone " +
            "or computer by your browser) to remember the options you last used, " +
            "so that the same options can be selected when you next access the site.\n" +
            "Click OK to permit this, or click Cancel to refuse permission."
        );
    }
    return navigator.cookieEnabled && permitCookies;
}

function setPreference(key, value) {
 	setCookie("Pref-" + key, value, 90);
}

function getPreference(key) {
 	return getCookie("Pref-" + key);
}

///////////////////////////////////// Preference Code ////////////////////////////////////

var gScalePref = "100";
var gBgAlphaPref = "100";
var gCompassAlphaPref = "100";
var gCompassStylePref = "Default Compass";
var gRotationPref = "0";
var gMarkerAnglePref = "0";
var gMarkerDirectionPref = "0";	// clockwise
var gCompassDeltaPref = "0";

function getPreferences() {
	var scale;
	var bgAlpha;
	var compassAlpha;
	var compassStyle;
	var rotation;
	var markerAngle;
	var markerDirection;
	var compassDelta;

    if (navigator.cookieEnabled) {
    	scale = getPreference("scalePref");
        if (scale !== "") {
        	gScalePref = scale;
         	permitCookies = true;
		}
    	bgAlpha = getPreference("bgAlphaPref");
        if (bgAlpha !== "") {
        	gBgAlphaPref = bgAlpha;
         	permitCookies = true;
		}
    	compassAlpha = getPreference("compassAlphaPref");
        if (compassAlpha !== "") {
        	gCompassAlphaPref = compassAlpha;
         	permitCookies = true;
		}
    	compassStyle = getPreference("compassStylePref");
        if (compassStyle !== "") {
        	gCompassStylePref = compassStyle;
         	permitCookies = true;
		}
    	rotation = getPreference("rotationPref");
        if (rotation !== "") {
        	gRotationPref = rotation;
         	permitCookies = true;
		}
    	markerAngle = getPreference("markerAnglePref");
        if (markerAngle !== "") {
        	gMarkerAnglePref = markerAngle;
         	permitCookies = true;
		}
    	markerDirection = getPreference("markerDirectionPref");
    	//alert("markerDirectionPref: " + markerDirection);
        if (markerDirection !== "") {
        	gMarkerDirectionPref = markerDirection;
         	permitCookies = true;
		}
    	compassDelta = getPreference("compassDeltaPref");
        if (compassDelta !== "") {
        	gCompassDeltaPref = compassDelta;
         	permitCookies = true;
		}
	}
}

getPreferences();				// pick up preferences stored as cookies

