/*		
	Resistors - A special purpose calculator to decode the colored bands on
	resistors (and small capacitors).
	Copyright © 2004-2015 Harry Whitfield

	This program is free software; you can redistribute it and/or modify it under
	the terms of the GNU General Public License as published by the Free Software
	Foundation; either version 2 of the License, or (at your option) any later
	version.

	This program is distributed in the hope that it will be useful, but WITHOUT ANY
	WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
	PARTICULAR PURPOSE.  See the GNU General Public License for more details.

	You should have received a copy of the GNU General Public License along with
	this program; if not, write to the Free Software Foundation, Inc., 51 Franklin
	St, Fifth Floor, Boston, MA  02110-1301  USA

	Resistors - browser version 1.0
	22 May, 2015
	Copyright 2004-2015 Harry Whitfield
	mailto:g6auc@arrl.net
*/

/*global newImage, newInput, newSelector, addToMenu, resValue */

/*properties
    index, length, onchange, onmousedown, onmouseup, opacity, open, pow, round,
    selectedIndex, style, title, toPrecision, toString, value
*/

///////////////////////////// Start of the resistors skeleton ////////////////////////////

//	mainWindow.width  = Math.round(scale * 280);
//	mainWindow.height = Math.round(scale * 318);

// newImage(hOffset, vOffset, width, height, src, zOrder, opacity)
// newText(hOffset, vOffset, width, height, value, zOrder, style)
// newTextArea(hOffset, vOffset, cols, rows, value, zOrder, style)
// newInput(hOffset, vOffset, width, height, value, zOrder, style)
// newCanvas(hOffset, vOffset, width, height, src, zOrder, opacity, hRegP, vRegP)
// newSelector(hOffset, vOffset, width, height, src, zOrder, opacity)

var componentPref     = "Resistor";
var bandsPref         = "3";
var internationalPref = "0";

var mBand	 = Number(bandsPref);

var band     = 1;	// takes values 1..4 and represents the state of the state machine
var value    = 0;
var key      = [];
var bands    = [];

var colors   = ["#000000", "#812900", "#FF0000", "#FF6E00", "#FFFB0A", "#37FF10", "#140CFF", "#E400FF", "#8D8D8D", "#FFFFFF", "#FFC400", "#CECECE"];
var tooltips = ["black x 1",  "brown x 10  1% (F)  100ppm",  "red x 100  2% (G)  50ppm",    "orange x 1000  15ppm", "yellow x 10,000  25ppm", "green x 100,000  0.5% (D)", 
				"blue x 1,000,000  0.25% (C)",   "violet x 10,000,000  0.1% (B)", "gray x 100,000,000  0.05% (A)",   "white x 1,000,000,000",  "gold",   "silver" ];

function buildVitality(color1, color2, color3, color4) {
	var base = "Resources/Swatches/";
	
	if (color1 !== undefined) { swatch1.src = base + "swatch" + String(color1) + ".png";  swatch1.style.opacity = 1.0; } else { swatch1.style.opacity = 0.0; }
	if (color2 !== undefined) { swatch2.src = base + "swatch" + String(color2) + ".png";  swatch2.style.opacity = 1.0; } else { swatch2.style.opacity = 0.0; }
	if (color3 !== undefined) { swatch3.src = base + "swatch" + String(color3) + ".png";  swatch3.style.opacity = 1.0; } else { swatch3.style.opacity = 0.0; }
	if (color4 !== undefined) { swatch4.src = base + "swatch" + String(color4) + ".png";  swatch4.style.opacity = 1.0; } else { swatch4.style.opacity = 0.0; }
}

function beep() { alert("Invalid Input"); }

function show(value, multiplier, unit) {	// multiplier -2..1
	var ls, ms;
	
	if (value > 99) {	// occurs when mBand === 4
		switch (multiplier) {
		case 1:
			return value + unit;
		case 0:
			ls = value %  10;
			ms = Math.round((value - ls) /  10);
			return ms + unit + ls;
		case -1:
			ls = value % 100;
			ms = Math.round((value - ls) / 100);
			ls = String(ls);
			if (ls.length === 1) { ls = "0" + ls; }
			return ms + unit + ls;
		default:
			beep();
			return "";
		}
	}
	// occurs when mBand === 3
	switch (multiplier) {
	case 1:
		return 10 * value + unit;
	case 0:
		return value + unit;
	case -1:
		ls = value % 10;
		ms = Math.round((value - ls) / 10);
		return ms + unit + ls;
	case -2:
		return "0" + unit + value;
	default:
		beep();
		return "";
	}
}

function internationalFormat(value, multiplier) {	// multiplier -2..9
	var prefix = ["p", "n", "µ", "m", "R", "k", "M", "G"],
		prBase = 0;
		
	if (componentPref === "Resistor") { prBase = 4; }

	if (value > 99) { multiplier += 1; }	// occurs when mBand === 4

	if (multiplier >= 8) {
		return show(value, multiplier - 9, prefix[prBase + 3]);
	}
	if (multiplier >= 5) {
		return show(value, multiplier - 6, prefix[prBase + 2]);
	}
	if (multiplier >= 2) {
		return show(value, multiplier - 3, prefix[prBase + 1]);
	}
	return show(value, multiplier,     prefix[prBase]);
}
      
function display(value, multiplier) {	// multiplier -2..9
	var strValue,
		temp = value,
		color4;

	if (internationalPref === "0") {	// use integer format
		temp = temp * Math.pow(10, multiplier);
		if (multiplier < 0) { strValue = temp.toPrecision(mBand - 1); } else { strValue = temp.toString(); }
		resValue.value = strValue;
		if (multiplier > 7) { strValue = internationalFormat(value, multiplier); }
	} else {	// use international format
		strValue = internationalFormat(value, multiplier);
		resValue.value = strValue;
	}
	color4 = undefined;
	if (mBand === 4) { color4 = bands[4]; }
	buildVitality(bands[1], bands[2], bands[3], color4);
}

function process() {// handles keys 0 to 9
	var s = this.index;
	
	this.style.opacity = 0.5;
	
	switch (band) {
	case 1:
		if (s !== 0) {
			buildVitality();
			bands[1] = Number(s);
			resValue.value  = s;
			value = Number(s);
			band = 2;
			return;
		}
		if (componentPref === "Resistor") {
			buildVitality(0);
			resValue.value  = internationalPref === "0" ? "0" : "0R";
			return;
		}
		buildVitality();
		resValue.value = "";
		beep();
		return;
	case 2: 
		bands[2] = Number(s);
		resValue.value += s;
		value = 10 * value + Number(s);
		band = 3;
		return;
	case 3:
		bands[3] = Number(s);
		if (mBand === 3) {
			display(value, Number(s));
			band = 1;
			return;
		}
		resValue.value += s;
		value = 10 * value + Number(s);
		band = 4;
		return;
	case 4:
		bands[4] = Number(s);
		display(value, Number(s));
		band = 1;
		return;
	default:
		beep();
		return; // invalid state
	}
}

function processStarHash() { // handles the * and # keys
	var multiplier = this.index;
	
	this.style.opacity = 0.5;
	if (band === mBand) { bands[band] = 9 - multiplier; display(value, multiplier); band = 1; } else { beep(); }
}

function processClear() { // handles the CLEAR key
	this.style.opacity = 0.5;
	resValue.value = "";
	buildVitality();
	band = 1;
}

function setOpacity255() { this.style.opacity = 1.0; }

//////////////////////////////////////////////////////////////////////////////////////////

var base = "Resources/Pictures/";

var background      = newImage(0, 168, 112, 20, base + "bg.png", 1, 1.0);

var keyStar         = newImage(0, 126, 28, 28, base + "star.png", 2, 1.0);
keyStar.index       = -2;
keyStar.onmouseup   = setOpacity255;
keyStar.onmousedown = processStarHash;
keyStar.title       = "silver x 0.01  10% (K)";

var keyHash    		= newImage(84, 126, 28, 28, base + "hash.png", 2, 1.0);
keyHash.index       = -1;
keyHash.onmouseup   = setOpacity255;
keyHash.onmousedown = processStarHash;
keyHash.title       = "gold x 0.1  5% (J)";

var clear           = newImage(42, 200, 28, 28, base + "CLR.png", 2, 1.0);
clear.onmouseup     = setOpacity255;
clear.onmousedown   = processClear;
clear.title         = "CLEAR";

var style = "font-size:14px;color:black;background-color:transparent;border:none;";

var resValue        = newInput(0, 168, 75, 1, "", 3, style);

function makeKeys() { //creates the images for keys 0 to 9
	var coords = [[42, 126], [0, 0], [42, 0], [84, 0], [0, 42], [42, 42], [84, 42], [0, 84], [42, 84], [84, 84]],
		i;
	
	for (i = 0; i < 10; i += 1) {
		key[i] = newImage(coords[i][0], coords[i][1], 28, 28, base + String(i) + ".png", 1, 1.0);
		key[i].index       = i;
		key[i].onmouseup   = setOpacity255;
		key[i].onmousedown = process;
		key[i].title       = tooltips[i];
	}
}

makeKeys();
resValue.value = "";

//////////////////////////////////////////////////////////////////////////////////////////

var helpButton  = newImage(190, 46, 30, 22, base + "help.png",    2);	// customized
helpButton.title  = "Displays information about this program.";
helpButton.onmousedown = function () { this.style.opacity = "0.5"; };
helpButton.onmouseup   = function () { this.style.opacity = "1.0"; window.open("Help.html"); };

var resistor = newImage(130, 163, 75, 30, base + "resistor.png", 2, 1.0);

base = "Resources/Swatches/";

var swatch1  = newImage(145, 170, 8, 16, base + "swatch4.png", 3, 0.0);
var swatch2  = newImage(157, 170, 8, 16, base + "swatch7.png", 3, 0.0);
var swatch3  = newImage(169, 170, 8, 16, base + "swatch6.png", 3, 0.0);
var swatch4  = newImage(181, 170, 8, 16, base + "swatch9.png", 3, 0.0);

//////////////////////////////////// Menus Customized ////////////////////////////////////

var MenuArray = [
	['Resistor', 'Capacitor'],
	['3', '4'],
	['Numerical', 'International']
];

var MenuTitleArray = [
	"Choose the type of component to be decoded.",
	"Choose the number of bands used to encode the value of the component.",
	"Choose how component values are to be displayed."
];

var MenuSelectedIndex = [0, 0, 0];

var Menu = [];

Menu[0] = newSelector(130,  4, 110, 20, "", 2);
Menu[1] = newSelector(130, 46, 110, 20, "", 2);
Menu[2] = newSelector(130, 88, 110, 20, "", 2);

var i;

for (i = 0; i < MenuArray.length; i += 1) {
	addToMenu(Menu[i],  MenuArray[i]);
	Menu[i].selectedIndex = MenuSelectedIndex[i];
	Menu[i].title = MenuTitleArray[i];
}

//////////////////////////////////////////////////////////////////////////////////////////

var componentPrefMenu     = Menu[0];
var bandsPrefMenu         = Menu[1];
var internationalPrefMenu = Menu[2];

componentPrefMenu.onchange  = function () {
	componentPref  = this.value;
	band           = 1;
	resValue.value = "";
	buildVitality();
};

bandsPrefMenu.onchange  = function () {
	bandsPref      = this.value;
	mBand	       = Number(bandsPref);
	band           = 1;
	resValue.value = "";
	buildVitality();
};

internationalPrefMenu.onchange  = function () {
	internationalPref = String(this.selectedIndex);
	band              = 1;
	resValue.value    = "";
	buildVitality();
};
