/*
    Roman Kalculator
    Copyright © 2016 Harry Whitfield

    This program is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by the
    Free Software Foundation; either version 2 of the License, or (at your
    option) any later version.

    This program is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.    See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA

    Roman Kalculator - version 1.0 browser version
    14 April, 2016
    Copyright © 2016 Harry Whitfield
    mailto:g6auc@arrl.net
*/

/*jslint browser, devel, for, multivar, this */

/*global window, newImage, newText, newInput, newSelector, addToMenu
*/

/*property
    close, color, fontSize, forEach, fromCharCode, height, index, indexOf,
    innerHTML, keyCode, length, match, maxWidth, navigator, onblur, onchange,
    onclick, onfocus, onfocusin, onfocusout, onkeydown, onkeypress,
    onmousedown, onmouseout, onmouseover, onmouseup, opacity, open,
    preventDefault, selectedIndex, src, style, substring, textAlign, title,
    toUpperCase, userAgent, value, which, width
*/

//////////////////////////////////////////////////////////////////////////////////////////

var window;	// browser
var newImage, newText, newInput, newSelector, addToMenu;	// webWidget.js
var coords, legends, keyCodes, keyIndex;	// keys.js
var goodRoman, toRoman, fromRoman;	// roman.js
var processOperator, doClear, doConstant, doDelete, doEnter, doNumber, doNumber2;	// compute.js

//////////////////////////////////////////////////////////////////////////////////////////

function logToFile() {
    "use strict";
	return;
}

function print() {
    "use strict";
	return;
}

function beep() {
    "use strict";
	return;
}

//////////////////////////////////////////////////////////////////////////////////////////

var paleGrey = "#CCCCCC";
var paleGreen = "#CCFFCC";
var white = "#FFFFFF";
var black = "#000000";
var red = "#FF0000";
var yellow = "#FFFF00";
var cyan = "#00FFFF";
var magenta = "#FF00FF";

var key = [];
var txt = [];
var keyZOrder = 20;
var txtZOrder = 30;
var keyScale = 42 / 28;
var keyMode2 = false;	// toggled by "2nd" key
var bsMode = false;     // clr or bs key set

var opSet = false, romanMode = false, parens = 0, degreeMode = false, hexMode = false;

//////////////////////////////////////////////////////////////////////////////////////////

var base, bkgd, redButton, amberButton, greenButton, helpButton, headingOne,
		roman, decimal, opDisplay, memDisplay, input;

(function () {
    "use strict";
    var style;

//  mainWindow.width = Math.round(scale * 520);
//  mainWindow.height = Math.round(scale * 610);

// newImage(hOffset, vOffset, width, height, src, zOrder, opacity) {
// newInput(hOffset, vOffset, size, height, value, zOrder, opacity) {
// newText(hOffset, vOffset, width, height, value, zOrder, style) {
// newTextArea(hOffset, vOffset, cols, rows, value, zOrder, style) {
// newCanvas(hOffset, vOffset, width, height, src, zOrder, opacity, hRegP, vRegP)


    base = "Resources/Backgrounds/";
    bkgd = newImage(0, 0, 520, 610, base + "greenBg.png", 1);

    base = "Resources/Images/";
    redButton = newImage(19, 10, 21, 14, base + "red.png", 2);
    amberButton = newImage(39, 10, 21, 14, base + "amber.png", 2);
    greenButton = newImage(59, 10, 14, 14, base + "green.png", 2);

    redButton.title = "Click to close the Widget.";
    amberButton.title = "";
    greenButton.title = "";

    helpButton = newImage(476, 9, 30, 22, base + "help.png", 2);
    helpButton.title = "Get information about this program.";

	style = "font-family:'Lucida Grande';font-weight:normal;font-size:14px;color:white;border:none;text-align:left";

    headingOne = newText(200, 7, 130, 20, "Roman Kalculator", 2, style);
    headingOne.style.color = white;
    headingOne.style.fontSize = "14px";

	style = "font-family:'Courier New';font-weight:normal;font-size:28px;color:white;border:none;text-align:right;background-color:#6F8983";

	roman = newText(20, 40, 480, 44, "", 2, style);
	roman.style.fontSize = "20px";
    decimal = newText(20, 100, 480, 44, "0", 2, style);
    opDisplay = newText(260, 160, 240, 44, "", 2, style);
    memDisplay = newText(20, 160, 240, 44, "M: 0", 2, style);
    memDisplay.style.textAlign = "left";

	style = "font-family:'Courier New';font-weight:normal;font-size:28px;color:white;border:none;text-align:center;background-color:#6F8983";

    input = newInput(16, 610, 180, 44, "", 3, style);	// input area for tablet computers
    input.style.maxWidth = "480px";

	roman.title = "Roman Number Display\n" +
    		"S       1/2 semis\n" +
    		"●     1/12 uncia\n" +
    		"£     1/24 semuncia\n" +
    		"$   1/144 dimidia sextula\n" +
    		"℈   1/288 scripulum\n" +
    		"» 1/1728 siliqua";

    decimal.title = "Decimal Number Display";
    opDisplay.title = "Displays last operator [operand]";
    memDisplay.title = "Memory Display";
}());

function displayNumber(numString) {
	"use strict";
    decimal.innerHTML = numString;
    roman.innerHTML = toRoman(Number(decimal.innerHTML));
}

function logDisplay(title) {
    "use strict";
    logToFile("---- " + title + " ----\n");
    logToFile(roman.innerHTML + "\n");
    logToFile(decimal.innerHTML + "\n");
    logToFile(opDisplay.innerHTML + "\n");
    logToFile(memDisplay.innerHTML + "\n");
}

//////////////////////////////////// Menus Customized ////////////////////////////////////

var MenuArray = [
    ["Degrees", "Radians"]
//    ["Line Mode", "Phase Mode"]
];

var MenuTitleArray = [
    "Choose how angles are to be input and displayed."
//    "Choose the Input Mode."
];

var MenuSelectedIndex = [1];	// , 0, 0, 5];

var Menu = [];

Menu[0] = newSelector(365, 10, 80, 20, "", 2);
//Menu[1] = newSelector(310, 17, 56, 20, "", 2);
//Menu[2] = newSelector(210, 80, 110, 20, "", 2);
//Menu[3] = newSelector(340, 80, 56, 20, "", 2);

(function () {
    "use strict";
    MenuArray.forEach(function (ele, i) {
        addToMenu(Menu[i], ele);
        Menu[i].selectedIndex = MenuSelectedIndex[i];
        Menu[i].title = MenuTitleArray[i];
    });
}());

Menu[0].onchange = function () {
    "use strict";
    degreeMode = Menu[0].selectedIndex === 0;
};

//////////////////////////////////////////////////////////////////////////////////////////

function displayOp(opString) {
	"use strict";
    opDisplay.innerHTML = opString;
}

function displayMemory(memString) {
	"use strict";
    memDisplay.innerHTML = memString;
}

function setOpSet(val) {
	"use strict";
   	opSet = val;
}

function goodDecimal(d) {   // checks decimal number
	"use strict";
   	var lookFor = /^([1-9][0-9]*|0)(\.[0-9]*)?([eE](\+?|-)\d{1,3})?$/;

    return (d.match(lookFor) !== null) && (d !== "");
}

function bsKey(on) {
	"use strict";
    if (on) {
        key[28].src = "Resources/Pictures/bs.png";
        key[28].title = "You may also use the Backspace key.";
    } else {
        key[28].src = "Resources/Pictures/clr.png";
        key[28].title = "You may also use the Escape or ForwardDelete keys.";
        input.value = "";
    }
    bsMode = on;
}

function processData(item) {
	"use strict";
    var romanData = "(MDCLXVIS●£$",
        decimalData = ".0123456789E+-",
 //		  hexData = ".0123456789ABCDEF",
		num;

    if (romanMode && ((item === "-") || (item === "+"))) {
        if (item === "-") {
            processOperator("-");
        } else {
            processOperator("+");
        }
        return;
    }

    if (romanData.indexOf(item) >= 0) {
        romanMode = true;
        if (opSet) {
            roman.innerHTML = "";
            bsKey(false);
			opSet = false;
        }
        if (goodRoman(roman.innerHTML + item)) { // check valid roman data
            roman.style.color = white;
            roman.innerHTML += item;
            bsKey(true);
            // set decimal data to the same
			num = fromRoman(roman.innerHTML, false);
			doNumber2(num);
			decimal.innerHTML = num;
            parens = 0;
		} else if (romanData.indexOf(item) >= 0) {
        	roman.style.color = yellow;
       		if (item === "(") {
        		if (parens < 2) {
        			parens += 1;
        			roman.innerHTML += item;
                    bsKey(true);
        		}
        	} else if (parens !== 0) {
        		roman.innerHTML += item;
        		while (parens > 0) {
        			roman.innerHTML += ")";
        			parens -= 1;
        		}
        		if (goodRoman(roman.innerHTML)) {
             		// set decimal data to the same
					num = fromRoman(roman.innerHTML, false);
					doNumber2(num);
					decimal.innerHTML = num;
              		roman.style.color = white;
              	} else {
              		decimal.innerHTML = "nan";
              	}
     		}
		}
    } else if (decimalData.indexOf(item) >= 0) {
        romanMode = false;
        doNumber(item);
        bsKey(true);
        if (goodDecimal(decimal.innerHTML)) {    // check valid decimal data
            decimal.style.color = white;
            return;
        }
		decimal.style.color = yellow;
        return;
    }

    if ((item === "π") || (item === "e")) {
        romanMode = false;
        doConstant(item);
        bsKey(true);
        return;
    }
}

function setLegends() {
    "use strict";
    var i;

    if (keyMode2) {
        legends[5] = "asin";
        legends[6] = "acos";
        legends[7] = "atan";
        legends[8] = "log";
        legends[9] = "asnh";
        legends[10] = "acsh";
        legends[11] = "atnh";
        legends[12] = "ln ";

       	legends[21] = "1st";
        legends[22] = "e";
        legends[23] = "$";
        legends[24] = "£";
        legends[25] = "x⁻¹";
        legends[26] = "√x";
        legends[27] = "√";

        legends[29] = "log2";
        legends[30] = "⌊ ⌋";
        legends[31] = "÷";

        keyCodes[22] = "e";
        keyCodes[23] = "$";
        keyCodes[24] = "£";
    } else {
        legends[5] = "sin";
        legends[6] = "cos";
        legends[7] = "tan";
        legends[8] = "10ⁿ";
        legends[9] = "sinh";
        legends[10] = "cosh";
        legends[11] = "tanh";
        legends[12] = "exp";

        legends[21] = "2nd";
        legends[22] = "π";
        legends[23] = "●";
        legends[24] = "S";
        legends[25] = "±";
        legends[26] = "x²";
        legends[27] = "^";

        legends[29] = " 2ⁿ";
        legends[30] = "⌈ ⌉";
        legends[31] = "%";

        keyCodes[22] = "π";
        keyCodes[23] = "●";
        keyCodes[24] = "S";
    }
	for (i = 5; i < 13; i += 1) {
		txt[i].innerHTML = legends[i];
		txt[i].style.color = (keyMode2)
			? yellow
			: black;
	}

	for (i = 21; i < 28; i += 1) {
		txt[i].innerHTML = legends[i];
		txt[i].style.color = (keyMode2)
			? yellow
			: black;
	}

 	for (i = 29; i < 32; i += 1) {
		txt[i].innerHTML = legends[i];
		txt[i].style.color = (keyMode2)
			? yellow
			: black;
	}

	txt[25].style.fontSize = (keyMode2)
		? "16px"
		: "24px";
}

function keyboard(item) {  // process keyboard input
	"use strict";
	var index = keyIndex[item],
    	num;

    if (index) {
        switch (item) {
        case "N":		// negate
        case "n":
        	item = "±";
        	break;
        case "R":		// reciprocal
        case "r":
        	item = "x⁻¹";
        	break;
        case "ß":		// square
			item = "x²";
			break;
        case "®":		// square root
        	item = "√x";
        	break;
    	case "ç":		// ceiling
    		item = "⌈ ⌉";
    		break;
    	case "ƒ":		// floor
    		item = "⌊ ⌋";
    		break;
    	}
        processOperator(item);
    } else if (item === "Backspace") {
    	if (romanMode) {
			roman.innerHTML = roman.innerHTML.substring(0, roman.innerHTML.length - 1);
        	if (goodRoman(roman.innerHTML)) { // check valid roman data
            	roman.style.color = white;
             	// set decimal data to the same
				num = fromRoman(roman.innerHTML, false);
				doNumber2(num);
				decimal.innerHTML = num;
				parens = 0;
        	} else if (roman.innerHTML === "") {
            	roman.style.color = white;
       			parens = 0;
       			decimal.innerHTML = "0";
       			bsKey(false);
        	} else {
         		roman.style.color = yellow;
        	}
		} else {
        	doDelete();
        	if (decimal.innerHTML === "") {
        		decimal.innerHTML = "0";
        		bsKey(false);
        	}
        	if (goodDecimal(decimal.innerHTML)) {    // check valid decimal data
             	decimal.style.color = white;
        	} else {
 				decimal.style.color = yellow;
			}
        }
    } else if (item === "Return") {
    	doEnter();
    } else if ((item === "Escape") || (item === "ForwardDelete")) {
		roman.innerHTML = "";
		roman.style.color = white;
		doClear();
		bsKey(false);
    } else if (item === "Tab") {
		keyMode2 = !keyMode2;
		setLegends();
    } else {
    	if ((item === "π") || (item === "e")) {
        	romanMode = false;
        	doConstant(item);
        	bsKey(true);
        	return;
    	}
		item = item.toUpperCase();
        if (item === "U") {
            item = "●";
        }
        processData(item);
    }
}

window.onkeydown = function (event) {
	"use strict";
	var item = event.which || event.keyCode;


    switch (item) {
    case 8:
    	keyboard("Backspace");
    	break;
    case 9:
    	event.preventDefault();
    	keyboard("Tab");
    	break;
    case 13:
    	keyboard("Return");
    	break;
    case 27:
    	keyboard("Escape");
    	break;
    case 46:
    	keyboard("ForwardDelete");
    	break;
    }
};

window.onkeypress = function (event) {
	"use strict";
	var item = event.which || event.keyCode;

	if (item > 32) {
		keyboard(String.fromCharCode(item));
	}
};

function process() {        // process clicks on buttons
	"use strict";
    var index = this.index,
        item = keyCodes[index],
        operator;

	if (item === 14) {		// 2nd button
		keyMode2 = !keyMode2;
		setLegends();
		return;
	}

    if (item === 18) {      // clr button
        if (bsMode) {
            keyboard("Backspace");
        } else {
            keyboard("Escape");
        }
        return;
    }

    if (typeof item === "string") {
        processData(item);
    } else {
    	switch (legends[index]) {
    	case "asnh":
    		operator = "asinh";
    		break;
    	case "acsh":
    		operator = "acosh";
    		break;
    	case "atnh":
    		operator = "atanh";
    		break;
    	default:
    		operator = legends[index];
    	}
        processOperator(operator);
    }
}

//////////////////////////////////////////////////////////////////////////////////////////

function opacity127() {
    "use strict";
	var i = this.index;

	key[i].style.opacity = 0.5;
}

function opacity255() {
    "use strict";
	var i = this.index;

	key[i].style.opacity = 1.0;
}

(function makeKeys(p, q) { //creates the images for the keys
    "use strict";
    var i,
        digits = "0123456789",
        fontSize,
        hOffset,
        vOffset,
        src,
        deltaY,
        style = "font-family:'Courier New';font-weight:normal;color:black;border:none;text-align:center";

    for (i = p; i <= q; i += 1) {
		hOffset = keyScale * coords[i][0] + 18;
		vOffset = keyScale * coords[i][1] + 220;

        if ((digits.indexOf(legends[i]) >= 0) || (i === 28)) {
            src = "Resources/Pictures/" + legends[i] + ".png";
        	key[i] = newImage(hOffset, vOffset, 42, 42, src, keyZOrder, 1.0);
        } else {
            src = "Resources/Pictures/blank.png";
       		key[i] = newImage(hOffset, vOffset, 42, 42, src, keyZOrder, 1.0);
           	fontSize = (legends[i].length > 2)
                ? "16px"
                : "24px";
            deltaY = (legends[i].length > 2)
            	? 4
            	: 0;
            txt[i] = newText(hOffset, vOffset + 8 + deltaY, 42, 42, legends[i], txtZOrder, style);
            txt[i].style.fontSize = fontSize;
            txt[i].index = i;
        	txt[i].onclick = process;
        	txt[i].onmouseover = opacity127;
        	txt[i].onmouseout = opacity255;
        }

 		key[i].index = i;
        key[i].onclick = process;
        key[i].onmouseover = opacity127;
        key[i].onmouseout = opacity255;
        key[i].title = "";
    }
    txt[16].title = "You may use the Left-parens '(' key once or twice to indicate 1,000 or 1,000,000 times the next Roman numeral entered.";
    txt[21].title = "You may use the Tab key.";
    txt[23].title = "'●' represents 1/12 (uncia). You may use the Letter-U key to enter a '●'." +
    		"\n\n'$' represents 1/144 (dimidia sextula).";
    txt[24].title = "'S' represents 1/2 (semis)\n\nand '£' represents 1/24 (semuncia).";
    txt[25].title = "'±' is the unary negate operator. You may use the Letter-N key.\n\nYou may use the Letter-R key for 'x⁻¹' which is the unary reciprocal operator.";
    txt[26].title = "You may use the alt-S key for 'x²' and the alt-R key for '√x'. Both are unary operators.";
   	txt[27].title = "'^' is the binary power operator. '√' is the binary root operator - you may use opt-V for '√'";
    key[28].title = "You may use the Escape or ForwardDelete keys.";
    txt[30].title = "'⌈ ⌉' is the unary ceiling operator. You may use the alt-C key." +
    		"\n\n'⌊ ⌋' is the unary floor operator. You may use the alt-F  key.";
    txt[31].title = "'%' is the binary modulo operator. '÷' is the binary div operator - use the alt-/ key for '÷'.";
    txt[47].title = "EXP is used to enter a decimal exponent. You may use the Letter-E key.";
    txt[48].title = "You may use the Return or Enter keys.";
}(1, 48));

//////////////////////////////////////////////////////////////////////////////////////////

//code to manage the three  (top left) colored buttons
var redButtonWithin = false;
var amberButtonWithin = false;
var greenButtonWithin = false;

var hasFocus = false;

function normalButtons() {
    "use strict";
    var base1 = "Resources/Images/";

    redButton.src = base1 + "red.png";
    amberButton.src = base1 + "amber.png";
    greenButton.src = base1 + "green.png";
}

function activeButtons() {
    "use strict";
    var base1 = "Resources/Images/";

    redButton.src = base1 + "redCross.png";
    amberButton.src = base1 + "amberMinus.png";
    greenButton.src = base1 + "greenPlus.png";
}

var focusButtons = function () {
    "use strict";
    var base1 = "Resources/Images/";

    if (hasFocus) {
    	redButton.src = base1 + "red.png";
    	amberButton.src = base1 + "amber.png";
    	greenButton.src = base1 + "green.png";
    } else {
     	redButton.src = base1 + "grey.png";
    	amberButton.src = base1 + "grey.png";
    	greenButton.src = base1 + "grey2.png";
    }
};

redButton.onmouseup = function () {
    "use strict";
    if (redButtonWithin) {
        normalButtons();
        window.close();
    }
};
redButton.onmousedown = function () {
    "use strict";
    redButtonWithin = true;
    activeButtons();
};
redButton.onmouseover = function () {
    "use strict";
    redButtonWithin = true;
    activeButtons();
};

redButton.onmouseout = function () {
    "use strict";
    redButtonWithin = false;
    focusButtons();
};

amberButton.onmouseup = function () {
    "use strict";
    if (amberButtonWithin) {
        normalButtons();
    }
};
amberButton.onmousedown = function () {
    "use strict";
    amberButtonWithin = true;
    activeButtons();
};
amberButton.onmouseover = function () {
    "use strict";
    amberButtonWithin = true;
    activeButtons();
};
amberButton.onmouseout = function () {
    "use strict";
    amberButtonWithin = false;
    focusButtons();
};

greenButton.onmouseup = function () {
	"use strict";
	if (greenButtonWithin) {
		normalButtons();
	}
};
greenButton.onmousedown = function () {
	"use strict";
    greenButtonWithin = true;
    activeButtons();
};
greenButton.onmouseover = function () {
    "use strict";
    greenButtonWithin = true;
    activeButtons();
};

greenButton.onmouseout = function () {
    "use strict";
    greenButtonWithin = false;
    focusButtons();
};

function onFocus() {
	"use strict";
	hasFocus = true;
	focusButtons();
}

function onBlur() {
	"use strict";
	hasFocus = false;
	focusButtons();
}

function isIE() {
	"use strict";
    var ua = window.navigator.userAgent;

	if (ua.indexOf("Edge/") > 0 || ua.indexOf("Trident/") > 0 || ua.indexOf("MSIE ") > 0) {
		return true;
	}
    return false;
}

if (isIE()) { // check for Internet Explorer
	document.onfocusin = onFocus;
	document.onfocusout = onBlur;
} else {
	window.onfocus = onFocus;
	window.onblur = onBlur;
}

//////////////////////////////////////////////////////////////////////////////////////////

helpButton.onmousedown = function () {
    "use strict";
    helpButton.style.opacity = "0.5";
};
helpButton.onmouseup = function () {
    "use strict";
    helpButton.style.opacity = "1.0";
    window.open("Help.html");
};

//////////////////////////////////////////////////////////////////////////////////////////
