/*
    Resistors - A special purpose calculator to decode the colored bands on
    resistors (and small capacitors).
    Copyright © 2004-2020 Harry Whitfield

    This program is free software; you can redistribute it and/or modify it under
    the terms of the GNU General Public License as published by the Free Software
    Foundation; either version 2 of the License, or (at your option) any later
    version.

    This program is distributed in the hope that it will be useful, but WITHOUT ANY
    WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
    PARTICULAR PURPOSE.  See the GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along with
    this program; if not, write to the Free Software Foundation, Inc., 51 Franklin
    St, Fifth Floor, Boston, MA  02110-1301  USA

    Resistors - browser version 3.0
    10 May, 2020
    Copyright 2004-2020 Harry Whitfield
    mailto:g6auc@arrl.net
*/

/*jslint browser, devel */

/*property
    bandsPref, componentPref, forEach, getItem, internationalPref, keys,
    setItem
*/

/////////////////////////////////// Storage Preferences //////////////////////////////////

let preferences = {};			  // default preferences

preferences.componentPref = "Resistor";
preferences.bandsPref = "3";
preferences.internationalPref = "0";
preferences.componentImagePref = "0";

const widgetName = "Resistors_Web";	// unique name of web widget

/////////////////////////////////// Storage Access Code //////////////////////////////////

function getPreference(key) {			// getPreference("keyCodesPref");
	let value;

	if (Storage !== undefined) {
		//alert("key: " + key);
		value = localStorage.getItem(widgetName + ":" + key);
		if (value !== null) {
			preferences[key] = value;
		}
	}
	return preferences[key];
}

function setPreference(key, value) {	// setPreference("keyCodesPref", keyCodesPref);
	preferences[key] = value;
	if (Storage !== undefined) {
		localStorage.setItem(widgetName + ":" + key, value);
	}
}

/*
function removePreference(key) {
	if (Storage !== undefined) {
		localStorage.removeItem(widgetName + ":" + key);
	}
}
*/

(function () {							// initial load of stored preferences
	Object.keys(preferences).forEach(function (key) {
		getPreference(key);
	});
}());

export {getPreference, setPreference};
