/*
	Series_To_Parallel_Conversion_Calculator
	Copyright © 2020 Harry Whitfield

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the
	Free Software Foundation; either version 2 of the License, or (at your
	option) any later version.

	This program is distributed in the hope that it will be useful, but
	WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
	General Public License for more details.

	You should have received a copy of the GNU General Public License along
	with this program; if not, write to the Free Software Foundation, Inc.,
	51 Franklin St, Fifth Floor, Boston, MA	 02110-1301	 USA

	Series_To_Parallel_Conversion_Calculator - browser version 1.2
	16 june, 2020
	Copyright © 2020 Harry Whitfield
	mailto:g6auc@arrl.net

	This version can be modified to have five param fields - see comments (****) below.
*/

/*jslint browser, devel */

/*property
    backgroundColor, border, clientX, close, hOffset, maxWidth, onclick,
    onmousedown, onmousemove, onmouseout, onmouseover, onmouseup, opacity, open,
    round, size, src, style, title, tracking, value, width
*/

import {fScale, newImage, newInput, moveObj, scale, setStyle} from "./webWidget.js";

//////////////////////////////////////////////////////////////////////////////////////////

//var main_window = {width: Math.round(280 * scale), height: Math.round(318 * scale)};
//var halfWidth = Math.round(main_window.width / 2);
//var halfHeight = Math.round(main_window.height / 2);

//////////////////////////////////////////////////////////////////////////////////////////

//	mainWindow.width = Math.round(scale * 280);
//	mainWindow.height = Math.round(scale * 318);

//	newImage(hOffset, vOffset, width, height, src, zOrder, opacity) {
//	newInput(hOffset, vOffset, size, height, value, zOrder, opacity) {
//	newTextArea(hOffset, vOffset, cols, rows, value, zOrder, readonly) {
//	newCanvas(hOffset, vOffset, width, height, src, zOrder, opacity, hRegP, vRegP)

var deltaH = 56;	// 0 for 4 params, 56 for 5 params	****

var base = "Resources/bkgd/";

var leftTop = newImage(0, 0, 40, 40, base + "bgleftTop.png", 1);
var leftMid = newImage(0, 40, 40, 225 + deltaH, base + "bgleftMid.png", 1);
var leftLow = newImage(0, 265 + deltaH, 40, 53, base + "bgleftLow.png", 1);

var middleTop = newImage(40, 0, 200, 40, base + "bgmiddleTop.png", 1);
var middleMid = newImage(40, 40, 200, 225 + deltaH, base + "bgmiddleMid.png", 1);
var middleLow = newImage(40, 265 + deltaH, 200, 53, base + "bgmiddleLow.png", 1);

var rightTop = newImage(240, 0, 40, 40, base + "bgrightTop.png", 1);
var rightMid = newImage(240, 40, 40, 225 + deltaH, base + "bgrightMid.png", 1);
var rightLow = newImage(240, 265 + deltaH, 40, 53, base + "bgrightLow.png", 1);

var dragbox = newImage(238, 271 + deltaH, 20, 20, base + "dragbox.png", 10);
dragbox.tracking = "rectangle";
dragbox.title = "Click to enable - move over me to change the widget's width - click again to disable.";

base = "Resources/buttons/";

var redButton = newImage(28, 21, 21, 14, base + "red.png", 2);
var amberButton = newImage(49, 21, 21, 14, base + "amber.png", 2);
var greenButton = newImage(70, 21, 14, 14, base + "green.png", 2);

var helpButton = newImage(260, 17, 48, 24, base + "help.png", 2);	// customized

redButton.title = "Click to close the Widget.";
amberButton.title = "Click to clear the data fields.";
greenButton.title = "Click to toggle the window size.";

helpButton.title = "Displays HELP information about this program.";

var execButton = newImage(138, 266 + deltaH, 64, 24, base + "execute.png", 10);
execButton.title = "Press to calculate, or press RETURN in one of the upper four entry fields.";

var title = newInput(88, 18, 164, 16, "", 2);						// customized
title.style.backgroundColor = "transparent";
title.style.border = "none";

base = "Resources/boxes/";

var leftBgOne = newImage(28, 44, 18, 39, base + "tbleft.png", 2);
var midBgOne = newImage(46, 44, 188, 39, base + "tbmiddle.png", 2);
var rightBgOne = newImage(234, 44, 18, 39, base + "tbright.png", 2);

var leftBgTwo = newImage(28, 100, 18, 39, base + "tbleft.png", 2);
var midBgTwo = newImage(46, 100, 188, 39, base + "tbmiddle.png", 2);
var rightBgTwo = newImage(234, 100, 18, 39, base + "tbright.png", 2);

var leftBgThree = newImage(28, 156, 18, 39, base + "tbleft.png", 2);
var midBgThree = newImage(46, 156, 188, 39, base + "tbmiddle.png", 2);
var rightBgThree = newImage(234, 156, 18, 39, base + "tbright.png", 2);

var leftBgFour = newImage(28, 212, 18, 39, base + "tbleft.png", 2);
var midBgFour = newImage(46, 212, 188, 39, base + "tbmiddle.png", 2);
var rightBgFour = newImage(234, 212, 18, 39, base + "tbright.png", 2);

var paramOne = newInput(37, 53, 200, 20, "", 3);
var paramTwo = newInput(37, 109, 200, 20, "", 3);
var paramThree = newInput(37, 165, 200, 20, "", 3);
var paramFour = newInput(37, 221, 200, 20, "", 3);

var font = "font-family:Courier;font-weight:normal;font-size:14px";

setStyle(paramOne, font);
setStyle(paramTwo, font);
setStyle(paramThree, font);
setStyle(paramFour, font);

paramOne.style.border = "none";
paramTwo.style.border = "none";
paramThree.style.border = "none";
paramFour.style.border = "none";

var headingOne = newInput(36, 74, 100, 16, "", 2);					// customized
var headingTwo = newInput(36, 130, 100, 16, "", 2);					// customized
var headingThree = newInput(36, 186, 108, 16, "", 2);				// customized
var headingFour = newInput(36, 242, 108, 16, "", 2);				// customized

headingOne.style.backgroundColor = "transparent";
headingTwo.style.backgroundColor = "transparent";
headingThree.style.backgroundColor = "transparent";
headingFour.style.backgroundColor = "transparent";

headingOne.style.border = "none";
headingTwo.style.border = "none";
headingThree.style.border = "none";
headingFour.style.border = "none";

/* Enable this code for 5 params	****/
var leftBgFive = newImage(28, 268, 18, 39, base + "tbleft.png", 2);
var midBgFive = newImage(46, 268, 188, 39, base + "tbmiddle.png", 2);
var rightBgFive = newImage(234, 268, 18, 39, base + "tbright.png", 2);

var paramFive = newInput(39, 277, 200, 20, "", 3);
setStyle(paramFive, font);
paramFive.style.border = "none";

var headingFive = newInput(36, 298, 108, 16, "", 2);				// customized
headingFive.style.backgroundColor = "transparent";
headingFive.style.border = "none";
/**/

//////////////////////////////////////////////////////////////////////////////////////////

var print = function (s) {
	alert(s);
};
var debug = false;
var minWidth = 300;		// customized
var maxWidth = 340;		// customized
var curWidth = maxWidth;
var dragEnabled = false;

function setUp(width) {
	if (debug) {
		print("setUp():======== start ========:");
		print("width=" + width);
		print("minWidth=" + minWidth);
		print("maxWidth=" + maxWidth);
	}

	if (width < minWidth) {
		width = minWidth;
	}
	if (width > maxWidth) {
		width = maxWidth;
	}

//	main_window.width = width;

	middleTop.width = width - 80;
	middleMid.width = width - 80;
	middleLow.width = width - 80;

	rightTop.hOffset = width - 40;
	moveObj(rightTop, width - 40, 0);
	moveObj(rightMid, width - 40, 40);
	moveObj(rightLow, width - 40, 265 + deltaH);

	midBgOne.width = width - 92;
	midBgTwo.width = width - 92;
	midBgThree.width = width - 92;
	midBgFour.width = width - 92;

	moveObj(rightBgOne, width - 46, 44);
	moveObj(rightBgTwo, width - 46, 100);
	moveObj(rightBgThree, width - 46, 156);
	moveObj(rightBgFour, width - 46, 212);

	dragbox.hOffset = width - 42;
	moveObj(dragbox, width - 42, 271 + deltaH);

	execButton.hOffset = width / 2 - 32;
	moveObj(execButton, width / 2 - 32, 266 + deltaH);

	paramOne.width = Math.round(scale * (width - 80));
	paramTwo.width = paramOne.width;
	paramThree.width = paramOne.width;
	paramFour.width = paramOne.width;

	paramOne.size = Math.round(scale * (width - 84) / fScale);
	paramTwo.size = paramOne.size;
	paramThree.size = paramOne.size;
	paramFour.size = paramOne.size;

	paramOne.style.maxWidth = Math.round(scale * (width - 84)) + "px";
	paramTwo.style.maxWidth = paramOne.style.maxWidth;
	paramThree.style.maxWidth = paramOne.style.maxWidth;
	paramFour.style.maxWidth = paramOne.style.maxWidth;

	/* Enable this code for 5 params	****/
	midBgFive.width = width - 92;
	moveObj(rightBgFive, width - 46, 268);
	paramFive.width = paramOne.width;
	paramFive.size = paramOne.size;
	paramFive.style.maxWidth = paramOne.style.maxWidth;
	/**/

	if (debug) {
		print("width=" + width);

//		print("main_window.width=" + main_window.width);
		print("middleTop.width=" + middleTop.width);
		print("rightTop.hOffset=" + rightTop.hOffset);
		print("paramOne.width=" + paramOne.width);
		print("dragbox.hOffset=" + dragbox.hOffset);

		print("setUp():========	 end ========:");
	}

	return width;
}

//////////////////////////////////////////////////////////////////////////////////////////

dragbox.onclick = function () {
	dragEnabled = !dragEnabled;
	if (dragEnabled) {
		helpButton.style.opacity = 0.0;
	} else {
		if (curWidth === maxWidth) {
			helpButton.style.opacity = 1.0;
		}
	}
};

dragbox.onmousemove = function (event) {
	if (dragEnabled) {
		moveObj(dragbox, event.clientX - 30, 271 + deltaH);
		curWidth = setUp(event.clientX - 30 + 42);
	}
};

function normalButtons() {
	var base1 = "Resources/buttons/";

	redButton.src = base1 + "red.png";
	amberButton.src = base1 + "amber.png";
	greenButton.src = base1 + "green.png";
}

function activeButtons() {
	var base1 = "Resources/buttons/";

	redButton.src = base1 + "redCross.png";
	amberButton.src = base1 + "amberMinus.png";
	greenButton.src = base1 + "greenPlus.png";
}

redButton.onmouseover = function () {
	activeButtons();
};

redButton.onmouseout = function () {
	normalButtons();
};

amberButton.onmouseover = function () {
	activeButtons();
};

amberButton.onmouseout = function () {
	normalButtons();
};

greenButton.onmouseover = function () {
	activeButtons();
};

greenButton.onmouseout = function () {
	normalButtons();
};

redButton.onclick = function () {
	window.close();
};

function clearData() {
	paramOne.value = "";
	paramTwo.value = "";
	paramThree.value = "";
	paramFour.value = "";
	/* Enable this code for 5 params	****
	paramFive.value = "";
	*/
}

amberButton.onclick = function () {
	clearData();
};

greenButton.onclick = function () {
	dragEnabled = false;

	if (curWidth === minWidth) {
		curWidth = setUp(maxWidth);
		helpButton.style.opacity = 1.0;
	} else {
		curWidth = setUp(minWidth);
		helpButton.style.opacity = 0.0;
	}
};

helpButton.onmousedown = function () {
	helpButton.style.opacity = "0.5";
};
helpButton.onmouseup = function () {
	helpButton.style.opacity = "1.0";
	window.open("Help.html");
};

setUp(maxWidth);

//////////////////////////////////////////////////////////////////////////////////////////

export {paramOne, paramTwo, paramThree, paramFour};
export {headingOne, headingTwo, headingThree, headingFour};
export {clearData, title, execButton};

/* Enable this code for 5 params	****/
export {paramFive};
export {headingFive};
/**/
