/*
    Wiring Calculator
    Copyright © 2010,2015 Harry Whitfield

    This program is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by the
    Free Software Foundation; either version 2 of the License, or (at your
    option) any later version.

    This program is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

    Wiring Calculator - browser version 1.0
    20 April, 2015
    Copyright © 2010,2015 Harry Whitfield
    mailto:g6auc@arrl.net
*/

/*jslint browser, multivar */

/*global scale, newImage, newInput, newSelector, addToMenu, alert, moveObj, fScale,
    window
*/

/*property
    PI, background, backgroundColor, border, clientX, close, forEach, hOffset,
    height, maxWidth, onclick, onmousedown, onmousemove, onmouseout,
    onmouseover, onmouseup, opacity, open, round, selectedIndex, setStyle,
    size, src, style, title, tracking, value, width
*/

//////////////////////////////////////////////////////////////////////////////////////////

var main_window = {width: Math.round(280 * scale), height: Math.round(318 * scale)},
    halfWidth = Math.round(main_window.width / 2),
    halfHeight = Math.round(main_window.height / 2),

    radToDeg = 180 / Math.PI,
    degToRad = Math.PI / 180,
    rotToPc = 100 / 360;

//////////////////////////////////////////////////////////////////////////////////////////

var base, leftTop, leftMid, leftLow, middleTop, middleMid, middleLow,
        rightTop, rightMid, rightLow, dragbox, redButton, amberButton, greenButton, title,
        leftBgOne, midBgOne, rightBgOne, leftBgTwo, midBgTwo, rightBgTwo,
        leftBgThree, midBgThree, rightBgThree, leftBgFour, midBgFour, rightBgFour,
        paramOne, paramTwo, paramThree, paramFour,
        headingOne, headingTwo, headingThree, headingFour, helpButton, font;

(function () {
    "use strict";
//  mainWindow.width = Math.round(scale * 280);
//  mainWindow.height = Math.round(scale * 318);

// newImage(hOffset, vOffset, width, height, src, zOrder, opacity) {
// newInput(hOffset, vOffset, size, height, value, zOrder, opacity) {
// newTextArea(hOffset, vOffset, cols, rows, value, zOrder, readonly) {
// newCanvas(hOffset, vOffset, width, height, src, zOrder, opacity, hRegP, vRegP)

    base = "Resources/bkgd/";

    leftTop = newImage(0, 0, 40, 40, base + "bgleftTop.png", 1);
    leftMid = newImage(0, 40, 40, 225, base + "bgleftMid.png", 1);
    leftLow = newImage(0, 265, 40, 53, base + "bgleftLow.png", 1);

    middleTop = newImage(40, 0, 200, 40, base + "bgmiddleTop.png", 1);
    middleMid = newImage(40, 40, 200, 225, base + "bgmiddleMid.png", 1);
    middleLow = newImage(40, 265, 200, 53, base + "bgmiddleLow.png", 1);

    rightTop = newImage(240, 0, 40, 40, base + "bgrightTop.png", 1);
    rightMid = newImage(240, 40, 40, 225, base + "bgrightMid.png", 1);
    rightLow = newImage(240, 265, 40, 53, base + "bgrightLow.png", 1);

    dragbox = newImage(238, 271, 20, 20, base + "dragbox.png", 2);
    dragbox.tracking = "rectangle";
    dragbox.title = "Click to enable - move over me to change the widget's width - click again to disable.";

    base = "Resources/buttons/";

    redButton = newImage(28, 21, 21, 14, base + "red.png", 2);
    amberButton = newImage(49, 21, 21, 14, base + "amber.png", 2);
    greenButton = newImage(70, 21, 14, 14, base + "green.png", 2);

    helpButton = newImage(413, 16, 30, 22, base + "help.png", 2);   // customized

    redButton.title = "Click to close the Widget.";
    amberButton.title = "Click to clear the data fields.";
    greenButton.title = "Click to toggle the window size.";

    helpButton.title = "Displays information about this program.";

    title = newInput(88, 18, 96, 16, "Wiring Calculator", 2);   // customized
    title.style.backgroundColor = "transparent";
    title.style.border = "none";

    base = "Resources/boxes/";

    leftBgOne = newImage(28, 44, 18, 39, base + "tbleft.png", 2);
    midBgOne = newImage(46, 44, 188, 39, base + "tbmiddle.png", 2);
    rightBgOne = newImage(234, 44, 18, 39, base + "tbright.png", 2);

    leftBgTwo = newImage(28, 100, 18, 39, base + "tbleft.png", 2);
    midBgTwo = newImage(46, 100, 188, 39, base + "tbmiddle.png", 2);
    rightBgTwo = newImage(234, 100, 18, 39, base + "tbright.png", 2);

    leftBgThree = newImage(28, 156, 18, 39, base + "tbleft.png", 2);
    midBgThree = newImage(46, 156, 188, 39, base + "tbmiddle.png", 2);
    rightBgThree = newImage(234, 156, 18, 39, base + "tbright.png", 2);

    leftBgFour = newImage(28, 212, 18, 39, base + "tbleft.png", 2);
    midBgFour = newImage(46, 212, 188, 39, base + "tbmiddle.png", 2);
    rightBgFour = newImage(234, 212, 18, 39, base + "tbright.png", 2);

    paramOne = newInput(39, 53, 200, 20, "", 3);
    paramTwo = newInput(39, 109, 200, 20, "", 3);
    paramThree = newInput(39, 165, 200, 20, "", 3);
    paramFour = newInput(39, 221, 200, 20, "", 3);

    paramOne.style.background = "rgba(192 ,192, 192, 1.0)";

    paramOne.title = "Circuit Length (in meters).";               // customized
    paramTwo.title = "Current (in amperes).";                     // customized
    paramThree.title = "Cross Section (in square millimeters).";    // customized
    paramFour.title = "Voltage Drop (in volts).";                  // customized

    font = "font-family:Courier;font-weight:normal;font-size:14px";

    paramOne.style.setStyle(font);
    paramTwo.style.setStyle(font);
    paramThree.style.setStyle(font);
    paramFour.style.setStyle(font);

    paramOne.style.border = "none";
    paramTwo.style.border = "none";
    paramThree.style.border = "none";
    paramFour.style.border = "none";

    headingOne = newInput(36, 74, 100, 16, "Circuit Length (m)", 2);   // customized
    headingTwo = newInput(36, 130, 60, 16, "Current (A)", 2);           // customized
    headingThree = newInput(36, 186, 125, 16, "Cross Section (mm^2)", 2);   // customized
    headingFour = newInput(36, 242, 95, 16, "Voltage Drop (V)", 2);       // customized

    headingOne.style.backgroundColor = "transparent";
    headingTwo.style.backgroundColor = "transparent";
    headingThree.style.backgroundColor = "transparent";
    headingFour.style.backgroundColor = "transparent";

    headingOne.style.border = "none";
    headingTwo.style.border = "none";
    headingThree.style.border = "none";
    headingFour.style.border = "none";
}());

//////////////////////////////////// Menus Customized ////////////////////////////////////

var MenuArray = [
    ["Circuit Length", "Current", "Cross Section", "Voltage Drop"],
    ["SI", "USA"],
    ["20°C = 68°F", "25°C = 77°F", "30°C = 86°F", "35°C = 95°F", "40°C = 104°F", "45°C = 113°F", "50°C = 122°F", "55°C = 131°F", "60°C = 140°F", "65°C = 149°F", "70°C = 158°F", "75°C = 167°F", "80°C = 176°F", "85°C = 185°F", "90°C = 194°F"],
    ["50%", "60%", "70%", "80%", "90%", "100%"]
];

var MenuTitleArray = [
    "Choose the Output Mode.",
    "Choose the Units.",
    "Choose the Temperature.",
    "Choose the Derating Constant."
];

var MenuSelectedIndex = [0, 0, 0, 5];

var Menu = [];

Menu[0] = newSelector(210, 17, 110, 20, "", 2);
Menu[1] = newSelector(340, 17, 56, 20, "", 2);
Menu[2] = newSelector(210, 80, 110, 20, "", 2);
Menu[3] = newSelector(340, 80, 56, 20, "", 2);

(function () {
    "use strict";
    MenuArray.forEach(function (ele, i) {
        addToMenu(Menu[i], ele);
        Menu[i].selectedIndex = MenuSelectedIndex[i];
        Menu[i].title = MenuTitleArray[i];
    });
}());

//////////////////////////////////////////////////////////////////////////////////////////

var print = function (s) {
    "use strict";
    alert(s);
};
var debug = false;
var minWidth = 225;     // customized
var maxWidth = 475;     // customized
var curWidth = maxWidth;
var dragEnabled = false;

function setUp(width) {
    "use strict";
    if (debug) {
        print("setUp():======== start ========:");
        print("width=" + width);
        print("minWidth=" + minWidth);
        print("maxWidth=" + maxWidth);
    }

    if (width < minWidth) {
        width = minWidth;
    }
    if (width > maxWidth) {
        width = maxWidth;
    }

    main_window.width = width;

    middleTop.width = width - 80;
    middleMid.width = width - 80;
    middleLow.width = width - 80;

    rightTop.hOffset = width - 40;
    moveObj(rightTop, width - 40, 0);
    moveObj(rightMid, width - 40, 40);
    moveObj(rightLow, width - 40, 265);

    midBgOne.width = width - 92;
    midBgTwo.width = width - 92;
    midBgThree.width = width - 92;
    midBgFour.width = width - 92;

    moveObj(rightBgOne, width - 46, 44);
    moveObj(rightBgTwo, width - 46, 100);
    moveObj(rightBgThree, width - 46, 156);
    moveObj(rightBgFour, width - 46, 212);

    dragbox.hOffset = width - 42;
    moveObj(dragbox, width - 42, 271);

    paramOne.width = Math.round(scale * (width - 80));
    paramTwo.width = paramOne.width;
    paramThree.width = paramOne.width;
    paramFour.width = paramOne.width;

    paramOne.size = Math.round(scale * (width - 84) / fScale);
    paramTwo.size = paramOne.size;
    paramThree.size = paramOne.size;
    paramFour.size = paramOne.size;

    paramOne.style.maxWidth = Math.round(scale * (width - 84)) + "px";
    paramTwo.style.maxWidth = paramOne.style.maxWidth;
    paramThree.style.maxWidth = paramOne.style.maxWidth;
    paramFour.style.maxWidth = paramOne.style.maxWidth;

    if (debug) {
        print("width=" + width);

//      print('main_window.width=' + main_window.width);
        print("middleTop.width=" + middleTop.width);
        print("rightTop.hOffset=" + rightTop.hOffset);
        print("paramOne.width=" + paramOne.width);
        print("dragbox.hOffset=" + dragbox.hOffset);

        print("setUp():========  end ========:");
    }

    return width;
}

//////////////////////////////////////////////////////////////////////////////////////////

dragbox.onclick = function () {
    "use strict";
    dragEnabled = !dragEnabled;
    if (dragEnabled) {
        MenuArray.forEach(function (ignore, i) {
            Menu[i].style.opacity = 0.0;
        });
        helpButton.style.opacity = 0.0;

    } else {
        if (curWidth === maxWidth) {
            MenuArray.forEach(function (ignore, i) {
                Menu[i].style.opacity = 1.0;
            });
            helpButton.style.opacity = 1.0;
        }
    }
};

dragbox.onmousemove = function (event) {
    "use strict";
    if (dragEnabled) {
        moveObj(dragbox, event.clientX - 10, 271);
        curWidth = setUp(event.clientX - 10 + 42);
    }
};

function normalButtons() {
    "use strict";
    var base1 = "Resources/buttons/";

    redButton.src = base1 + "red.png";
    amberButton.src = base1 + "amber.png";
    greenButton.src = base1 + "green.png";
}

function activeButtons() {
    "use strict";
    var base1 = "Resources/buttons/";

    redButton.src = base1 + "redCross.png";
    amberButton.src = base1 + "amberMinus.png";
    greenButton.src = base1 + "greenPlus.png";
}

redButton.onmouseover = function () {
    "use strict";
    activeButtons();
};

redButton.onmouseout = function () {
    "use strict";
    normalButtons();
};

amberButton.onmouseover = function () {
    "use strict";
    activeButtons();
};

amberButton.onmouseout = function () {
    "use strict";
    normalButtons();
};

greenButton.onmouseover = function () {
    "use strict";
    activeButtons();
};

greenButton.onmouseout = function () {
    "use strict";
    normalButtons();
};

redButton.onclick = function () {
    "use strict";
    window.close();
};

function clearData() {
    "use strict";
    paramOne.value = "";
    paramTwo.value = "";
    paramThree.value = "";
    paramFour.value = "";
}

amberButton.onclick = function () {
    "use strict";
    clearData();
};

greenButton.onclick = function () {
    "use strict";
    dragEnabled = false;

    if (curWidth === minWidth) {
        curWidth = setUp(maxWidth);
        MenuArray.forEach(function (ignore, i) {
            Menu[i].style.opacity = 1.0;
        });
        helpButton.style.opacity = 1.0;
    } else {
        curWidth = setUp(minWidth);
        MenuArray.forEach(function (ignore, i) {
            Menu[i].style.opacity = 0.0;
        });
        helpButton.style.opacity = 0.0;
    }
};

helpButton.onmousedown = function () {
    "use strict";
    helpButton.style.opacity = "0.5";
};
helpButton.onmouseup = function () {
    "use strict";
    helpButton.style.opacity = "1.0";
    window.open("Help.html");
};

setUp(maxWidth);
